package com.yeejoin.amos.latentdanger.common.remote;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.latentdanger.business.util.HttpUtil;
import com.yeejoin.amos.latentdanger.common.enums.WorkFlowRiskFactorUriEnum;
import com.yeejoin.amos.latentdanger.core.common.request.LatentDangerResultPushSpcRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Map;

@Service("remoteSpcService")
public class RemoteSpcService {

    private final Logger logger = LoggerFactory.getLogger(RemoteSpcService.class);

    @Value("${params.spc.address}")
    private String address;

    private static final String success = "SUCCESS";

    private String buildUrl(String address, WorkFlowRiskFactorUriEnum workFlowRiskFactorUriEnum, Map<String, String> map) {
        String uri = workFlowRiskFactorUriEnum.getUri();
        String params = workFlowRiskFactorUriEnum.getParams();
        if (!StringUtils.isEmpty(params) && map != null) {
            String[] paramsArr = params.split(",");
            for (String param : paramsArr) {
                uri = uri.replace("{" + param + "}", map.get(param));
            }
        }
        return address + uri;
    }

    private JSONObject handleResult(String resultStr) {
        if (resultStr == null) {
            return null;
        }
        JSONObject json = JSON.parseObject(resultStr);
        if (success.equals(json.getString("result"))) {
            return json;
        }
        return null;
    }

    public JSONObject pushLatentDangerExecuteResult(LatentDangerResultPushSpcRequest latentDangerResultPushSpcRequest) {
        String url = buildUrl(address, WorkFlowRiskFactorUriEnum.隐患治理结果推送, null);
        String stringJson = JSONObject.toJSONString(latentDangerResultPushSpcRequest);
        String resultStr = HttpUtil.sendHttpPostJson(url, stringJson);
        logger.info("\r\n请求路径=======================>" + url + "\r\n请求参数=======================>" + stringJson + "\r\n返回参数=======================>" + resultStr);
        return handleResult(resultStr);
    }
}
