package com.yeejoin.amos.boot.module.jxiop.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 场站基础信息表
 *
 * @author system_generator
 * @date 2023-04-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "StationBasicDto", description = "场站基础信息表")
public class StationBasicDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "场站名称")
    private String stationName;

    @ApiModelProperty(value = "场站编号")
    private String stationCode;

    @ApiModelProperty(value = "场站类型")
    private String stationType;

    @ApiModelProperty(value = "场站类型名称")
    private String stationTypeName;

    @ApiModelProperty(value = "项目状态")
    private String stationFlag;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty(value = "站长")
    private String stationMasterName;

    @ApiModelProperty(value = "站长id")
    private Integer stationMasterId;

    @ApiModelProperty(value = "联系方式（手机）")
    private String mobilePhone;

    @ApiModelProperty(value = "电话")
    private String phone;

    @ApiModelProperty(value = "邮箱")
    private String email;

    @ApiModelProperty(value = "运维开始时间")
    private String devopsTime;

    @ApiModelProperty(value = "所属地区")
    private List<Integer> belongArea;

    @ApiModelProperty(value = "业主单位")
    private String ownerUnit;

    @ApiModelProperty(value = "简介")
    private String briefIntroduction;

    @ApiModelProperty(value = "场站log")
    private String stationLogo;

    @ApiModelProperty(value = "所属片区")
    private String area;

    @ApiModelProperty(value = "所属片区code")
    private String areaCode;

    @ApiModelProperty(value = "所属地区名称")
    private String areaName;

    @ApiModelProperty(value = "组织机构")
    private String projectOrgCode;

    @ApiModelProperty(value = "岗位")
    private String postName;

    @ApiModelProperty(value = "三维跳转路径")
    private String jumpPath;

    @ApiModelProperty(value = "平台关联场站id")
    private String platformStationId;

    @ApiModelProperty(value = "坐标列表")
    private List<StationCoordinateDto> stationCoordinate;

    //新增 场站第三方编号
    private String stationNumber;
    //新增场站 设备检测网关
    private String gatewayId;
}
