package com.yeejoin.amos.boot.module.jxiop.biz.controller;


import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.Test;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MonitorFanIndicatorImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.SjglZsjZsbtzServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationBasicServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.TestServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.auth.In;
import net.logstash.logback.encoder.org.apache.commons.lang3.StringUtils;
import org.influxdb.dto.QueryResult;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@RestController
@Api(tags = "Demo-test")
@RequestMapping(value = "/demo")
public class DemoController extends BaseController {

    @Autowired
    StationBasicServiceImpl stationBasicServiceimpl;
    @Autowired
    TestServiceImpl testServiceimpl;
    @Autowired
    RedisUtils redisUtils;

    @Autowired
    StationBasicMapper stationBasicMapper;

    @Autowired
    InfluxDbConnection influxDbConnection;
    @Autowired
    SjglZsjZsbtzServiceImpl sjglZsjZsbtzServiceImpl;

    @Autowired
    MonitorFanIndicatorImpl monitorFanIndicatorImpl;
    @Autowired
    InfluxDButils influxDButils;


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "demo测试prodcutcion 库")
    @GetMapping("/test")
    public StationBasic demoTest() {
        return stationBasicServiceimpl.getById(1660231556607774721L);
    }
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "demo测试中间库")
    @GetMapping("/test1")
    public List<Test> demoTest1() {
        return testServiceimpl.getList();
    }
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "demo测试influxdb")
    @GetMapping("/test3")
    public void demoTest2() {
        String sql = "SELECT createdTime ,gatewayId,address,valueLabel FROM \"iot_data\" WHERE equipmentSpecificName=~/.*27风机.*/  and  gatewayId='1668801435891929089'    GROUP BY equipmentIndex    ORDER BY time  desc  LIMIT 600";
        List<IndexDto> list=influxDButils.getListData(sql,IndexDto.class);
        System.out.println(list.size());
    }
    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "测试获取风速平均值")
    @GetMapping("/test4")
    public void demoTest3() {
        Object o=this.monitorFanIndicatorImpl.getIndicatoralueAvage("1668801435891929089","60秒平均风速");
        System.out.println(o.toString());
    }



}
