package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.api.dto.DeviceDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.PersonAccountDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.RegionNationWideDto;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/7/4
 */

@RestController
@Api(tags = "device")
@RequestMapping(value = "/device")
public class DeviceController extends BaseController {

    @Autowired
    InfluxDButils influxDButils;


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取告警数据")
    @GetMapping("/nationwide")
    public ResponseModel<Page<IndexDto>> getNationWideInfo(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size,@RequestParam(value = "gateway") String gateway) {
        Page<IndexDto> page = new Page<IndexDto>();
        page.setCurrent(current);
        page.setSize(size);
        StringBuffer querysql = new StringBuffer("SELECT createdTime ,gatewayId,address,valueLabel,equipmentSpecificName,value FROM iot_data WHERE isAlarm='1'   and value!='0.0'  and   time > now() - 1d ");
        StringBuffer querysqlcount = new StringBuffer("SELECT count(value) FROM iot_data WHERE isAlarm='1'   and value!='0.0'  and   time > now() - 1d ");
        if(StringUtils.isNotEmpty(gateway)){
           String[] da= gateway.split(",");
            for (int i = 0; i < da.length; i++) {
                if(i==0){
                    querysql.append("and  ( gatewayId = ").append("'"+da[i]+"'");
                    querysqlcount.append("and  ( gatewayId = ").append("'"+da[i]+"'");

                }else if(i==da.length-1){
                    querysql.append(" or gatewayId = ").append("'"+da[i]+"'").append(") ");
                    querysqlcount.append(" or gatewayId = ").append("'"+da[i]+"'").append(") ");

                }else{
                    querysql.append(" or gatewayId = ").append("'"+da[i]+"'");
                    querysqlcount.append(" or gatewayId = ").append("'"+da[i]+"'");

                }
            }
        }
        querysql.append(" ORDER BY time  desc   LIMIT ").append(page.getSize()).append(" OFFSET ").append((page.getCurrent() - 1)*page.getSize());
        //每个分机的指标数据
        List<IndexDto> list = influxDButils.getListData(querysql.toString(),IndexDto.class);
        List<IndexDto> list1 = influxDButils.getListData(querysqlcount.toString(),IndexDto.class);
        page.setRecords(list);
        if(list1!=null&&list1.size()>0){
            page.setTotal(list1.get(0).getCount());
        }
        return ResponseHelper.buildResponse(page);
    }










}
