package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jxiop.api.dto.RunRecord;
import com.yeejoin.amos.boot.module.jxiop.api.dto.TreeDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.MonitorFanIndicator;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MonitorFanIndicatorImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@RestController
@Api(tags = "大屏相关API")
@RequestMapping(value = "/monitorFanIdx")
public class MonitorFanIdxController extends BaseController {

    @Autowired
    MonitorFanIndicatorImpl monitorFanIndicatorImpl;

    @Autowired
    MonitorFanIndicatorImpl monitorFanIndicator;


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据设备编号、网关ID、前段展示模块查询表数据")
    @GetMapping("/getFanIdxInfoByPage")
    public ResponseModel<IPage<MonitorFanIndicator>> getFanIdxInfoByPage(@RequestParam(value = "equipmentNumber", required = false) String equipmentNumber,
                                                                         @RequestParam(value = "gateway", required = false) String gateway,
                                                                         @RequestParam(value = "frontModule", required = false) String frontModule,
                                                                         @RequestParam(value = "current", required = false) int current,
                                                                         @RequestParam(value = "size", required = false) int size) {
        return ResponseHelper.buildResponse(monitorFanIndicator.getFanIdxInfoByPage(equipmentNumber, gateway, frontModule, current, size));
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "左侧树API")
    @GetMapping("/getTreeInfo")
    public ResponseModel<TreeDto> getTreeInfo(@RequestParam(value = "sequenceNbr", required = true) String sequenceNbr) {
        return ResponseHelper.buildResponse(monitorFanIndicator.getTreeInfo(sequenceNbr));
    }


    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "运行记录")
    @GetMapping("/runRecord")
    public ResponseModel<IPage<RunRecord>> runRecord(
                                               @RequestParam(value = "gateway", required = false) String gateway,
                                               @RequestParam(value = "current", required = false) int current,
                                               @RequestParam(value = "size", required = false) int size) {

        String[] gateways=gateway.split(",");
        IPage<RunRecord> page=  monitorFanIndicator.queryRunRecord( size,gateways,  current);
        return ResponseHelper.buildResponse(page);
    }




}
