package com.yeejoin.amos.boot.module.jxiop.biz.controller;


import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IMapRegionService;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.RegionNationWideDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.SocialContributionDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.Test;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MonitoringServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.RegionServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationBasicServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.TestServiceImpl;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.aspectj.apache.bcel.classfile.Module;
import org.influxdb.dto.QueryResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@RestController
@Api(tags = "监盘地图接口")
@RequestMapping(value = "/monitormap")
public class MonitoringMapController extends BaseController {

    @Autowired
    MonitoringServiceImpl monitoringServiceImpl;

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取监盘全国地图数据")
    @GetMapping("/nationwide")
    public ResponseModel<List<RegionNationWideDto>> getNationWideInfo(@RequestParam (value = "provinceName", required = false)String provinceName) {
      return ResponseHelper.buildResponse(monitoringServiceImpl.getNationWideInfo(provinceName));
    }

    @TycloudOperation(needAuth = false, ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取社会贡献")
    @GetMapping("/getTotalSocialContribution")
    public ResponseModel<List<SocialContributionDto>> getTotalSocialContribution() {
        return ResponseHelper.buildResponse(monitoringServiceImpl.getTotalSocialContribution());
    }
}
