package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.RunRecord;
import com.yeejoin.amos.boot.module.jxiop.api.dto.TreeDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.MonitorFanIndicator;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.MonitorFanIndicatorMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.RegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IMonitorFanIndicator;
import com.yeejoin.amos.component.robot.BadRequest;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/7/3
 */
@Service
public class MonitorFanIndicatorImpl implements IMonitorFanIndicator {

    @Autowired
    private MonitorFanIndicatorMapper monitorFanIndicatorregionMapper;

    @Autowired
    private StationBasicMapper stationBasicMapper;

    @Autowired
    private RegionMapper regionMapper;

    @Override
    public void UpdateMonitorFanIndicator(List<IndexDto> list) {

        monitorFanIndicatorregionMapper.UpdateMonitorFanIndicator(list);




    }

    public IPage<MonitorFanIndicator> getFanIdxInfoByPage(String equipmentNumber, String gateway, String frontModule, int current, int size) {
        Page<MonitorFanIndicator> page = new Page<>(current, size);
        Integer integer = monitorFanIndicatorregionMapper.queryByPageTotal(equipmentNumber, gateway, frontModule);
        List<MonitorFanIndicator> monitorFanIndicators = monitorFanIndicatorregionMapper.queryByPage(page.getSize(), equipmentNumber, gateway, frontModule, (current - 1) * size);
        page.setTotal(integer);
        page.setRecords(monitorFanIndicators);
        return page;
    }

    public TreeDto getTreeInfo(String sequenceNbr) {
        StationBasic stationBasic = stationBasicMapper.selectById(sequenceNbr);
        List<Integer> integers = JSON.parseArray(stationBasic.getBelongArea(), Integer.class);
        if (CollectionUtils.isEmpty(integers)) {
            throw new BadRequest("所属地区不能为空");
        }
        LambdaQueryWrapper<Region> regionLambda = new LambdaQueryWrapper<>();
        regionLambda.eq(Region::getRegionCode, integers.get(0));
        Region region = regionMapper.selectOne(regionLambda);
        TreeDto treeDto = new TreeDto();
        treeDto.setCode(String.valueOf(region.getRegionCode()));
        treeDto.setName(region.getRegionName());
        treeDto.setId(String.valueOf(region.getSequenceNbr()));
        treeDto.setParentCode("0");
        treeDto.setIsOnClick(0);
        List<TreeDto> stationListByRegionCode = stationBasicMapper.getStationListByRegionCode(String.valueOf(region.getRegionCode()));


        TreeDto fdzTreeDto = new TreeDto();
        fdzTreeDto.setName("风电站");
        fdzTreeDto.setCode("FDZ");
        fdzTreeDto.setParentCode(String.valueOf(region.getRegionCode()));
        fdzTreeDto.setIsOnClick(0);
        List<TreeDto> fdz = stationListByRegionCode.stream().filter(t -> t.getParentCode().equals("FDZ")).collect(Collectors.toList());
        fdzTreeDto.setChildren(fdz);

        TreeDto gfzTreeDto = new TreeDto();
        gfzTreeDto.setName("光伏站");
        gfzTreeDto.setCode("GFZ");
        gfzTreeDto.setParentCode(String.valueOf(region.getRegionCode()));
        gfzTreeDto.setIsOnClick(0);
        List<TreeDto> gfz = stationListByRegionCode.stream().filter(t -> t.getParentCode().equals("GFZ")).collect(Collectors.toList());
        gfzTreeDto.setChildren(gfz);
        List<TreeDto> treeDtos = Arrays.asList(fdzTreeDto, gfzTreeDto);
        treeDto.setChildren(treeDtos);
        return treeDto;
    }

    /**
     * 根据网关与指标获取指标的平均值
     * @param gateway
     * @param indicator
     * @return
     */
    public Object getIndicatoralueAvage(String gateway,String indicator){
        return  monitorFanIndicatorregionMapper.getIndicatoralueAvage(gateway,indicator);
    }





    public IPage<RunRecord>  queryRunRecord(long size,String[] gateway, int current){

        Page<RunRecord> page = new Page<>(current, size);
        Integer integer = monitorFanIndicatorregionMapper.queryRunRecordTotal(gateway);
        List<RunRecord> runRecord = monitorFanIndicatorregionMapper.queryRunRecord(page.getSize(),  gateway,  (current - 1) * size);
        page.setTotal(integer);
        page.setRecords(runRecord);
        return page;


    }

    /**
     * 根据网关与指标获取指标的总值
     * @param gateway
     * @param indicator
     * @return
     */
    public Object getIndicatoralueTotal(String gateway,String indicator){
        return  monitorFanIndicatorregionMapper.getIndicatoralueTotal(gateway,indicator);
    }


}

