package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.injector.methods.SelectOne;
import com.yeejoin.amos.boot.module.jxiop.api.entity.Region;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationCoordinate;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.RegionMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationCoordinateMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.RegionNationWideDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.SocialContributionDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Service
public class MonitoringServiceImpl {
    /**
     * 区域mapper
     */
    @Autowired
    RegionMapper regionMapper;
    /**
     * 场站mapper
     */
    @Autowired
    StationBasicMapper stationBasicMapper;
    /**
     *  场站坐标mapper
     */
    @Autowired
    StationCoordinateMapper stationCoordinateMapper;
    /***
     * 设备基础信息中间表数据-热工院
     */
    @Autowired
    SjglZsjZsbtzServiceImpl  SjglZsjZsbtzServiceImpl;

    /**
     * 热工院-数据字典表
     */
    @Autowired
    TpriDmpDatabookServiceImpl  TpriDmpDatabookServiceImpl;

    @Autowired
    MonitorFanIndicatorImpl monitorFanIndicatorImpl;
    /**
     * 根据省份名称查询电站详情
     * @param provinceName
     * @return
     */
   public List<RegionNationWideDto> getNationWideInfo(String provinceName){
        List<RegionNationWideDto> regionNationWideDtoList= new ArrayList<>();
        //如果 provinceName 为空则表示当前为全国地图 否则则为省份地图
        if(ObjectUtils.isEmpty(provinceName)||provinceName.equals("")){
            List<Region> regionList  = this.regionMapper.selectList(new QueryWrapper<Region>().eq("level",1));
            for (int i = 0; i < regionList.size(); i++) {
                RegionNationWideDto regionNationWideDto  = new RegionNationWideDto();
                AtomicReference<Double> guangfuMW = new AtomicReference<>(0.0);
                AtomicReference<Double> fengdianMW = new AtomicReference<>(0.0);
                AtomicReference<Integer> guangfu = new AtomicReference<>(0);
                AtomicReference<Integer> fengdian = new AtomicReference<>(0);
                Region region = regionList.get(i);
                List<StationBasic> list = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().like("belong_area",region.getRegionCode()));
                list.forEach(stationBasic -> {
                    if(!ObjectUtils.isEmpty(stationBasic.getGatewayId())&&!ObjectUtils.isEmpty(stationBasic.getStationNumber())){
                        regionNationWideDto.setJsJoin(true);
                    }
                    if(stationBasic.getStationType().equals("FDZ")){
                        fengdianMW.set(getStationCaPACITYL(stationBasic.getStationNumber()));
                        fengdian.getAndSet(fengdian.get() + 1);
                    }else {
                        guangfuMW.set(getStationCaPACITYL(stationBasic.getStationNumber()));
                        guangfu.getAndSet(guangfu.get() + 1);
                    }
                });
                regionNationWideDto.setFengdian(fengdian.toString());
                regionNationWideDto.setGuangfu(guangfu.toString());
                regionNationWideDto.setGuangfuMW(guangfuMW.toString());
                regionNationWideDto.setFengdianMV(fengdianMW.toString());
                regionNationWideDto.setName(region.getRegionName());
                regionNationWideDtoList.add(regionNationWideDto);
            }
        }else {
            Region region = this.regionMapper.selectOne(new QueryWrapper<Region>().eq("level",1).eq("region_name",provinceName));
            List<StationBasic> list = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().like("belong_area",region.getRegionCode()));
            HashMap<String,Double> hashMap = new HashMap<>();
            for (int i = 0; i <list.size() ; i++) {
                StationBasic stationBasic = list.get(i);
                RegionNationWideDto regionNationWideDto =new RegionNationWideDto();
                regionNationWideDto.setStaitionName(stationBasic.getStationName());
                regionNationWideDto.setStaitionType(stationBasic.getStationType());
                String speendOrirradiate = "";
                if(stationBasic.getStationType().equals("FDZ")){
                    speendOrirradiate = String.valueOf( getIndicatoralueAvage(stationBasic.getGatewayId(),"30秒平均风速"));
                    regionNationWideDto.setSpeendOrirradiate(speendOrirradiate);
                }else{
                    regionNationWideDto.setSpeendOrirradiate(String.valueOf(Math.random()*1000));
                }
                StationCoordinate stationCoordinate = stationCoordinateMapper.selectOne(new QueryWrapper<StationCoordinate>().eq("station_id",stationBasic.getSequenceNbr()).eq("is_main_coordinate",0));
                hashMap.put("lng", Double.valueOf(stationCoordinate.getLongitude()));
                hashMap.put("lat", Double.valueOf(stationCoordinate.getLaitude()));
                regionNationWideDto.setPosition(hashMap);
                regionNationWideDtoList.add(regionNationWideDto);
            }

        }
        return regionNationWideDtoList;
    }

    /**
     * 根据场站编号获取该场站的装机容量
     * @param werks
     * @return
     */
    public Double getStationCaPACITYL(String werks){
       return this.SjglZsjZsbtzServiceImpl.getStationCapactityByStationWerks(werks);
    }

    /**
     * 根据网关id以及指标值 获取同一网关下指标的平均值
     * @param gateway 网关id
     * @param indicatorcName 指标名称
     * @return 同一网关下指标的平均值
     */
    public Object getIndicatoralueAvage (String gateway ,String indicatorcName){
        return this.monitorFanIndicatorImpl.getIndicatoralueAvage(gateway,indicatorcName);
    }
    /**
     * 根据网关id以及指标值 同一网关下指标的值总和
     * @param gateway 网关id
     * @param indicatorcName 指标名称
     * @return 同一网关下指标的值总和
     */
    public Object getIndicatoralueTotal (String gateway ,String indicatorcName){
        return this.monitorFanIndicatorImpl.getIndicatoralueTotal(gateway,indicatorcName);
    }

    public List<SocialContributionDto>  getTotalSocialContribution(){
        List<SocialContributionDto> socialContributionDtoList =new ArrayList<>();
        AtomicReference<Double> totalSocialContribution = new AtomicReference<>(0.0);
        //获取所有网关id不为空的数据
        List<StationBasic> stationBasicList = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().isNotNull("gateway_id"));
        stationBasicList.forEach(stationBasic -> {
            totalSocialContribution.updateAndGet(v -> v + (Double) monitorFanIndicatorImpl.getIndicatoralueTotal(stationBasic.getGatewayId(), "年发电量"));
        });
        SocialContributionDto co2 = new SocialContributionDto();
        SocialContributionDto coal = new SocialContributionDto();
        SocialContributionDto toner = new SocialContributionDto();
        SocialContributionDto so2 = new SocialContributionDto();
       /** 社会贡献原始计算公式，后边的数据已经经过处理
        //二氧化碳计算公式  *10000*832/10000/1000/1000
        //标准煤计算公式  *10000*304.9/10000/1000/1000
        //碳粉尘计算公式 *10000*0.032/1000/1000
        //二氧化硫计算公式  =A2*10000*0.16/1000/1000
        */
        co2.setUnit("二氧化碳减排量（万t）");
        co2.setTitle(totalSocialContribution.get() * 0.000832);
        socialContributionDtoList.add(co2);
        coal.setUnit("节约标准煤（万t）");
        coal.setTitle(totalSocialContribution.get() * 0.0003049);
        socialContributionDtoList.add(coal);
        toner.setUnit("碳粉尘减排量（万t）");
        toner.setTitle(totalSocialContribution.get() * 0.00032);
        socialContributionDtoList.add(toner);
        so2.setUnit("二氧化硫减排量（万t）");
        so2.setTitle(totalSocialContribution.get() * 0.0016);
        socialContributionDtoList.add(so2);
        return  socialContributionDtoList;
    }
}
