package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.module.jxiop.api.dto.DeviceDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.IndexDto;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationTaksDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.service.IStationDataTask;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.SjglZsjZsbtz;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.TpriDmpDatabook;
import com.yeejoin.amos.boot.module.jxiop.biz.utils.InfluxDButils;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import org.influxdb.dto.QueryResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Component
public class StationDataTaskImpl {
    @Autowired
    StationBasicServiceImpl stationBasicServiceImpl;

    @Autowired
    SjglZsjZsbtzServiceImpl sjglZsjZsbtzServiceImpl;

    @Autowired
    TpriDmpDatabookServiceImpl tpriDmpDatabookServiceImpl;
    @Autowired
    InfluxDbConnection influxDbConnection;
    @Autowired
    MonitorFanIndicatorImpl monitorFanIndicatorImpl;
    @Value("${station.section}")
    private int stationSection;
    @Value("${station.isok}")
    private boolean  isok;

    @Autowired
    InfluxDButils influxDButils;
    @Autowired
    MonitorFanIndicatorAsync monitorFanIndicatorAsync;

    /**
     * 获取 List<StationTaksDto>
     * @return <StationTaksDto>
     */
    public List<StationTaksDto> getListStationBasic() {
        return stationBasicServiceImpl.getStationTaksDtoList();
    }


    /**
     * @deprecated 获取该场站下所有的风机信息
     * @param stationTaksDto
     * @return  List<DeviceDto> 设备信息列表
     */
    public List<DeviceDto> getListDevice(StationTaksDto stationTaksDto) {
        List<DeviceDto> deviceDtoList =   new ArrayList<>();
        //获取风机的字典id
        TpriDmpDatabook tpriDmpDatabook =  tpriDmpDatabookServiceImpl.getTpriDmpDatabookByDataName("风机");
        //根据字典id与场站编码获取所有的风机列表
        List<SjglZsjZsbtz> sjglZsjZsbtzList  = sjglZsjZsbtzServiceImpl .getSjglZsjZsbtzList(tpriDmpDatabook.getDataid(),stationTaksDto.getStationNumber());
        //遍历风机列表对于需要的参数进行组装
        sjglZsjZsbtzList.forEach(sjglZsjZsbtz -> {
            DeviceDto deviceDto = new DeviceDto();
            deviceDto.setGateway(stationTaksDto.getGateway());
            String kksbm = sjglZsjZsbtz.getKksbm();
            String [] kksbms = kksbm.split(" ");
            String numberName = kksbms[kksbms.length-1].replace("MD","");
            deviceDto.setNumberName(numberName);
            deviceDtoList.add(deviceDto);
        });
        return deviceDtoList;
    }

    @Async("jxiopAsyncExecutor")
    public List<IndexDto> getIndexDto(DeviceDto deviceDto) {
        String querysql ="SELECT createdTime ,gatewayId,address,valueLabel ,equipmentsIdx   FROM iot_data WHERE equipmentSpecificName=~/.*"+deviceDto.getNumberName()+"风机"+".*/  and  gatewayId='"+deviceDto.getGateway()+"'   ORDER BY time  desc  LIMIT 600";
        //每个分机的指标数据
        List<IndexDto> list = influxDButils.getListData(querysql,IndexDto.class);
        if(list!=null&&list.size()>0){
            //对数据切片处理 默认创建
            if(stationSection>list.size()||!isok){
                monitorFanIndicatorImpl.UpdateMonitorFanIndicator(list);
            }else{
                //进行分片处理

                List<List<IndexDto>>  listfp4= Lists.partition(list,stationSection);
                for (List<IndexDto> indexDtos : listfp4) {
                    //每个分级信息处理
                    monitorFanIndicatorAsync.UpdateMonitorFanIndicator(indexDtos);
                }
            }
        }

        return list;
    }





}
