package com.yeejoin.precontrol.common.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 作业活动关联人员
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_task_person")
@ApiModel(value = "TaskPerson对象", description = "作业活动关联人员")
public class TaskPerson extends BaseEntity {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "任务id")
	private Long taskId;
	@ApiModelProperty(value = "人员id")
	private Long personId;
	@ApiModelProperty(value = "人员名称")
	private String personName;
	@ApiModelProperty(value = "人员类型（0主持人，1交底人，2施工负责人，3安全员，4记录人，5交底人员，6技术员，7工程人员，8施工人员，9违章人员  99 发布人 10 分包商负责人 15薪资确认人）")
	private Long type;
	@ApiModelProperty(value = "阅读状态")
	private Long readStatus = 0L;
	@ApiModelProperty(value = "阅读时间")
	private Date readTime;
	@ApiModelProperty(value = "企业id")
	private Long companyId;
	@ApiModelProperty(value = "薪资")
	private BigDecimal salary;
	@ApiModelProperty(value = "出勤天数")
	private Integer clockDays;
	@ApiModelProperty(value = "第一次阅读(红点显示)")
	private Boolean firstRead = false;
	@ApiModelProperty(value = "考试id")
	private Long examId;
	@ApiModelProperty(value = "考试模板id")
	private Long examTemplateId;
	@ApiModelProperty(value = "考试名称")
	private String examName;
	@ApiModelProperty(value = "考试状态")
	private Integer examStatus;
	@ApiModelProperty(value = "知识id")
	private Long knowledgeId;
	@ApiModelProperty(value = "知识名称")
	private String knowledgeName;
	@ApiModelProperty(value = "知识分类id")
	private Long knowledgeCategoryId;
	@ApiModelProperty(value = "知识状态")
	private Integer knowledgeStatus;
	@ApiModelProperty(value = "过期时间")
	private Date expireDate;
	@ApiModelProperty(value = "是否进入风险区域")
	private Integer inRiskRegion;
	private Long constructDocumentId;
	private Integer constructDocumentStatus;
	private Long TechDocumentId;
	private Integer TechDocumentStatus;
	private Long constructDisclosureDocumentId;
	private Integer constructDisclosureDocumentStatus;
	private Boolean checked;
}
