package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum ProjectInitiationEnum {
    项目立项("1","项目立项","XMLX","被驳回，请重新申请","",""),

    设计开工资料提交("2","设计提交资料","SJZLTJ","设计资料待提交","设计提交资料","待提交"),
    安装开工资料提交("3","安装提交资料","AZZLTJ","安装资料待提交","安装提交资料","待提交"),

    设计资料审核("","设计资料审核","SJZISH","设计资料待审核","设计资料审核","待审核"),
    设计资料审批("","设计资料审批","SJZISP","设计资料待审批","设计资料审批","待审批"),

    建设负责人指定项目负责人("","建设负责人分配项目负责人","","建设负责人分配项目负责人","建设负责人分配项目负责人","待审核"),
    建设负责人指定项目资料员("","建设项目负责人分配项目资料员","","建设项目负责人分配项目资料员","建设项目负责人分配项目资料员","待审核"),
    设计负责人指定项目负责人("","设计负责人分配项目负责人","","设计负责人分配项目负责人","设计负责人分配项目负责人","待审核"),
    设计负责人指定项目资料员("","设计项目负责人分配资料员","","设计项目负责人分配资料员","设计项目负责人分配资料员","待审核"),
    安装负责人指定项目负责人("","安装负责人分配项目负责人","","安装负责人分配项目负责人","安装负责人分配项目负责人","待审核"),
    安装负责人指定项目资料员("","安装项目负责人分配资料员","","安装项目负责人分配资料员","安装项目负责人分配资料员","待审核"),

    建设单位资料员预审("","建设单位资料员预审","","建设单位资料员预审","建设单位资料员预审","待审核"),
    项目负责任人审核("","项目负责任人审核","","项目负责任人审核","项目负责任人审核","待审核"),
    负责人审批("","负责人审批","","负责人审批","负责人审批","待审核"),

    提交指定("6","提交指定","TJZL","","",""),

    安装资料审核("","安装资料审核","AZZLSH","安装资料待审核","安装资料审核","待审核"),
    安装资料审批("","安装资料审批","AZZLSP","安装资料待审批","安装资料审批","待审批"),

    告知申请("4","告知申请","GZSQ","告知待申请","告知申请","待申请"),
    接受告知("5","接收告知","JSGZ","告知待接收","告知接收","待接收"),
    //设计和安装合并使用。
    提交资料("6","提交资料","TJZL","项目资料待提交","提交资料","待提交"),
    监检科室分配("6","监检科室分配","JJKSFP","监检科室待分配","监检科室分配","待分配"),
    监检员分配("7","监检员分配","JJYFP","监检员待分配","监检员分配","待分配"),
    监检员审核("8","监检员审核","JJYSH","监检员待审核","监检员审核","待审核"),
    设计开工资料修改("9","设计修改资料","SJZLXG","设计资料待修改","设计修改资料","待修改"),
    安装开工资料修改("10","安装修改资料","AZZLXG","安装资料待修改","安装修改资料","待修改"),
    // 设计和安装都需要修改时合并使用
    修改资料("","修改资料","","资料待修改","修改资料","待修改"),
    流程结束("11","流程结束！","LCJS","立项成功！","","");

    private String status;
    private String name;
    private String code;
    private String taskDetailStatus;
    private String taskName;
    private String taskStatus;

    public static Map<String,String> getNameByStatusMap = new HashMap<String,String>();
    public static Map<String,String> getStatusByNameMap = new HashMap<String,String>();
    public static Map<String,String> getCodeByNameMap = new HashMap<String,String>();
    public static Map<String,String> getTaskStatusMap = new HashMap<String, String>();
    public static Map<String,String> getTaskNameMap = new HashMap<String, String>();
    public static Map<String, String> getTaskDetailStatusMap = new HashMap<String, String>();

    static {
        for(ProjectInitiationEnum projectInitiationEnum:ProjectInitiationEnum.values()){
            getNameByStatusMap.put(projectInitiationEnum.status,projectInitiationEnum.name);
            getStatusByNameMap.put(projectInitiationEnum.name, projectInitiationEnum.status);
            getCodeByNameMap.put(projectInitiationEnum.name,projectInitiationEnum.code);
            getTaskStatusMap.put(projectInitiationEnum.name,projectInitiationEnum.taskStatus);
            getTaskNameMap.put(projectInitiationEnum.name,projectInitiationEnum.taskName);
            getTaskDetailStatusMap.put(projectInitiationEnum.name,projectInitiationEnum.taskDetailStatus);
        }
        for(OverProjectFlowEnum overProject:OverProjectFlowEnum.values()){
            getTaskDetailStatusMap.put(overProject.getName(),overProject.getTaskDetailStatus());
        }
    }

}
