package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 项目资源表（包括焊工、管材、设备）
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_ugp_project_resource")
public class ProjectResource extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 项目id
     */
	@TableField("project_id")
    private Long projectId;

    /**
     * 资源名称
     */
	@TableField("name")
    private String name;

    /**
     * 资源类型（welder、material、equipment）
     */
	@TableField("type")
    private String type;

    /**
     * 资源id
     */
	@TableField("resource_id")
    private Long resourceId;

    /**
     * 告知资料审核状态  1 合格  0 不合格（默认合格）
     */
    @TableField("status")
    private String status;


    /**
     * 流程实例id
     */
    @TableField("instance_id")
    private String instanceId;

    /**
     * 审核状态
     */
    @TableField("audit_status")
    private String auditStatus;

    /**
     * 备注（最新审批记录）
     */
    @TableField("remark")
    private String remark;
}
