package com.yeejoin.amos.boot.module.ugp.api.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.EquipmentDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectProcessDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Equipment;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 项目信息表 Mapper 接口
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Mapper
public interface ProjectMapper extends BaseMapper<Project> {

    //通过name查询一条数据
    ProjectDto selectOneByName(@RequestParam String name);

    ProjectDto getDetail(Long sequenceNbr);
    //项目模糊筛选
    IPage<ProjectDto> queryProjectPage(IPage<ProjectDto> page, Project project, String roleName, String companyId,Set<String> codes);

    List<String> projectScheduleSuperviseName(Long companyId);

    List<String> projectScheduleSuperviseNum(Long companyId);

    List<String> projectScheduleInspectionName(Long companyId);

    List<String> projectScheduleInspectionNum(Long companyId);


    String projectBuiltDept(Long companyId);

    String projectUnderConstructionDept(Long companyId);

    String projectBuiltUnit(Long companyId);

    String projectUnderConstructionUnit(Long companyId);

    /**
     * 获取当前登陆人所在单位下的项目情况（已完成、未完成）
     * @param projectIds
     * @return
     */
    List<Map<String,String>> getProjectComplete(@Param("projectIds") Set<Long> projectIds);
    ProjectProcessDto getProjectProcessDto(Long sequenceNbr);

    String getContext(String instanceId,String taskName);

    Double getProjectSchedule(@Param("projectId") Long projectId);
    Float getLengths();

}
