package com.yeejoin.amos.boot.module.ugp.api.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.aspectj.weaver.ast.Test;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 项目资源表（包括焊工、管材、设备） Mapper 接口
 *
 * @author system_generator
 * @date 2022-09-22
 */
@Mapper
public interface ProjectResourceMapper extends BaseMapper<ProjectResource> {

    //焊机设备表
    Page<WelderEquipmentDto> WelderEquipment(IPage<WelderEquipmentDto> page, @Param("name") String name, @Param("type") String type);

    Page<WelderEquipmentDto> selectByName(Page<WelderEquipmentDto> page, @Param("name") String name, @Param("unit") String unit);

    Page<WelderEquipmentDto> selectByInfo(Page<WelderEquipmentDto> page, @Param("info") Test info, @Param("unit") String unit);

    WelderEquipmentDto customSelectById(@Param("sequenceNbr") Long sequenceNbr);

    //管材页面分页,根据名称、编号筛选
    Page<ProjectMaterialDto>  MaterialPage(IPage<ProjectMaterialDto> page ,@Param("name") String name, @Param("code") String code);

    //根据resource_id删除项目焊工人员信息
    Boolean deleteByResourceId(Long resourceId);

    /**
     * 获取当前登录人所在单位下的所有项目
     * 根据登录人角色去筛选
     */
    List<Project> getProjectPage(String roleName, String companyId, Set<String> codes);

    List<ProjectResourceDto> getProjectMaterial(String type, Set<String> codes, @RequestBody(required = false) ProjectResourceDto projectResourceDto);
    List<ProjectResourceDto> getProjectEquipment(String type, Set<String> codes,@RequestBody(required = false) ProjectResourceDto projectResourceDto);


    String selectInstanceId(@Param("projectId") Long projectId, @Param("type") String type);

    Page<Map<String, Object>> getWelders(@Param("page") Page<Map<String, Object>> page, @Param("projectId") Long projectId);

    Page<Map<String, Object>> getEquipments(@Param("page") Page<Map<String, Object>> page, @Param("projectId") Long projectId);

    Page<Map<String, Object>> getMaterials(@Param("page") Page<Map<String, Object>> page, @Param("projectId") Long projectId);
}
