package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.mysql.cj.xdevapi.JsonString;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.common.api.entity.OrgUsr;
import com.yeejoin.amos.boot.module.common.api.mapper.DynamicFormInstanceMapper;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.ugp.api.Enum.OrgEnum;
import com.yeejoin.amos.boot.module.ugp.api.Enum.TabLogoEnum;
import com.yeejoin.amos.boot.module.ugp.api.constants.XJConstant;
import com.yeejoin.amos.boot.module.ugp.api.dto.*;
import com.yeejoin.amos.boot.module.ugp.api.entity.InstallNotice;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectInitiation;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import com.yeejoin.amos.boot.module.ugp.api.mapper.CompanyMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectResourceMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IProcessRelationService;
import com.yeejoin.amos.boot.module.ugp.biz.framework.BusinessIdentify;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.*;
import com.yeejoin.amos.component.robot.BadRequest;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.util.*;

import static com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type.Int;

/**
 * 项目信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "项目信息表Api")
@RequestMapping(value = "/project")
public class ProjectController extends BaseController {

	@Autowired
	ProjectServiceImpl projectServiceImpl;
	@Autowired
	ProjectMapper projectMapper;

	@Autowired
	private CompanyServiceImpl companyServiceImpl;
	@Autowired
	private RedisUtils  redisUtils;
	@Autowired
	ProjectInitiationServiceImpl projectInitiationService;
	@Autowired
	CompanyMapper companyMapper;
	@Autowired
	OrgServiceImpl orgServiceImpl;
	@Autowired
	EquipmentServiceImpl equipmentService;
	@Autowired
	AttachmentServiceImpl attachmentServiceImpl;
	@Autowired
	ProjectResourceServiceImpl projectResourceServiceImpl;
	@Autowired
	InstallNoticeServiceImpl iInstallNoticeService;
	@Autowired
	ProjectOverFlowServiceImpl projectOverFlowService;

	@Autowired
	IProcessRelationService iProcessRelationService;

	@Autowired
	ProjectResourceMapper projectResourceMapper;

	@Autowired
	DynamicFormInstanceMapper dynamicFormInstanceMapper;
	/**
	 * 新增项目信息表
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增项目信息表", notes = "新增项目信息表")
	@BusinessIdentify
	public ResponseModel<ProjectDto> save(@RequestBody ProjectDto model,String submitType) {
		return ResponseHelper.buildResponse(projectServiceImpl.saveProjectInfo(model,submitType));
	}

	/**
	 * 根据sequenceNbr更新
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新项目信息表", notes = "根据sequenceNbr更新项目信息表")
	public ResponseModel<ProjectDto> updateBySequenceNbrProject(@RequestBody ProjectDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		model.setRecDate(new Date());
		model.setSequenceNbr(sequenceNbr);
		return ResponseHelper.buildResponse(projectServiceImpl.updateWithModel(model));
	}

	/**
	 * 根据sequenceNbr删除
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@DeleteMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除项目信息表", notes = "根据sequenceNbr删除项目信息表")
	public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
		return ResponseHelper.buildResponse(projectServiceImpl.removeById(sequenceNbr));
	}

	/**
	 * 根据sequenceNbr查询
	 *
	 * @param sequenceNbr 主键
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个项目信息表", notes = "根据sequenceNbr查询单个项目信息表")
	public ResponseModel<ProjectDto> selectOne(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(projectServiceImpl.selectById(sequenceNbr));
	}

	/**
	 * 列表分页查询
	 *
	 * @param current 当前页
	 * @param current 每页大小
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "项目信息表分页查询",  notes = "项目信息表分页查询")
	public ResponseModel<IPage<ProjectDto>> queryForPage(String current,String size, Project project) {
		return ResponseHelper.buildResponse(projectServiceImpl.queryProjectPage(current,size,project));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/homePage")
	@ApiOperation(httpMethod = "GET", value = "项目信息表分页查询-首页表格", notes = "项目信息表分页查询-首页表格")
	public ResponseModel<IPage<Project>> homePage(int current, int size, String name, String code) {
		Page<Project> projectPage = new Page<>(current, size);
		LambdaQueryWrapper<Project> lambda = new QueryWrapper<Project>().lambda();
		lambda.eq(Project::getIsDelete, false);
		if (!ObjectUtils.isEmpty(name)) {
			lambda.eq(Project::getName, name);
		}
		if (!ObjectUtils.isEmpty(code)) {
			lambda.eq(Project::getCode, code);
		}
		IPage<Project> projectIPage = projectServiceImpl.getBaseMapper().selectPage(projectPage, lambda);
		return ResponseHelper.buildResponse(projectIPage);
	}


	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "项目信息表列表全部数据查询",   notes = "项目信息表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<ProjectDto>> selectForList() {
		return ResponseHelper.buildResponse(projectServiceImpl.queryForProjectList());
	}

	/**
	 * 查询项目名称
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询项目名称", notes = "查询项目名称")
	@GetMapping(value = "/selectName")
	public ResponseModel<List<JSONObject>> selectName() {
		return ResponseHelper.buildResponse(projectServiceImpl.selectName());
	}

	/**
	 * 获取下拉选择值
	 * @param type INSTALL("安装单位")、DESIGN("设计单位")、SUPERVISION（”监察单位“）、MONITORING（”监检机构“）
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询下拉选择框的值", notes = "查询下拉选择框的值")
	@GetMapping(value = "/getSelectInfo")
	public ResponseModel<List<OrgUsr>> getSelectInfo(String type){
		return ResponseHelper.buildResponse(orgServiceImpl.getSelectInfo(type));
	}

	/**
	 * 查询监检机构下的人员列表
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询下拉选择框的值", notes = "查询下拉选择框的值")
	@GetMapping(value = "/getDepPerson")
	public ResponseModel<List<OrgUsr>> getDepPerson(String insDepId){
		return ResponseHelper.buildResponse(orgServiceImpl.getVerInfo(insDepId));
	}

	/**
	 * 查询当前登录单位下的人员列表
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询下拉选择框的值", notes = "查询下拉选择框的值")
	@GetMapping(value = "/getCharge")
	public ResponseModel<List<OrgUsr>> getCharge(@RequestParam(required = false) Long sequenceNbr){
		return ResponseHelper.buildResponse(orgServiceImpl.getCharge(sequenceNbr));
	}

	/**
	 * 查询当前登陆人所在单位下的所以项目列表
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询当前登陆人所在单位下的所以项目列表", notes = "查询当前登陆人所在单位下的所以项目列表")
	@GetMapping(value = "/getCompanyProjects")
	public ResponseModel<List<Project>> getCompanyProjects(){
		Long companyId = null;
		//获取当前登陆人所在单位id
//		companyId = orgServiceImpl.getCompanyId();
//		if(ValidationUtil.isEmpty(companyId)){
//			return ResponseHelper.buildResponse(new ArrayList<>());
//		}
		LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
		if (!ValidationUtil.isEmpty(companyId)) {
			wrapper.eq(Project::getConstructionUnitId,companyId);
		}

		return ResponseHelper.buildResponse(projectServiceImpl.list(wrapper));
	}

	/**
	 * 项目审核
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "Post", value = "项目审核", notes = "项目审核")
	@PostMapping(value = "/processProject")
	public ResponseModel<String> processProject(@RequestParam("sequenceNbr") String sequenceNbr,String option,@RequestBody JSONObject j){
		JSONObject json = j.getJSONObject("fileInfo");
		Project project = projectServiceImpl.getById(sequenceNbr);
		JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(project));
		jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"审核通过");
		String insDepId = json.getString(XJConstant.INS_DEPID);
		String insPerson = json.getString(XJConstant.INS_PRESON);
		String jsfz = json.getString(XJConstant.JSFZ_PRESON);
		String jszl = json.getString(XJConstant.JSZL_PRESON);
		String sjfz = json.getString(XJConstant.SJFZ_PRESON);
		String sjzl = json.getString(XJConstant.SJZL_PRESON);
		String azfz = json.getString(XJConstant.AZFZ_PRESON);
		String azzl = json.getString(XJConstant.AZZL_PRESON);
		String condition = json.getString(XJConstant.CONDITION);
		if(!ValidationUtil.isEmpty(insPerson)){
			Map map = orgServiceImpl.getdetialInfo(insDepId);
			jsonObject.put(XJConstant.INS_PRESON,insPerson);
			//添加监检科室的回显
			jsonObject.put(XJConstant.INS_DEP,map.get("name"));
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"监检员待审核");
		} else if (!ValidationUtil.isEmpty(insDepId)) {
			Map map = orgServiceImpl.getdetialInfo(insDepId);
			jsonObject.put(XJConstant.INS_DEPID,map.get("sequenceNbr"));
			jsonObject.put(XJConstant.INS_DEP,map.get("name"));
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"ssss");
		} else if (!ValidationUtil.isEmpty(jsfz)) {
			jsonObject.put(XJConstant.INS_PRESON,jsfz);
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"建设负责人分配项目负责人");
		} else if (!ValidationUtil.isEmpty(jszl)) {
			jsonObject.put(XJConstant.INS_PRESON,jszl);
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"建设项目负责人分配项目资料员");
		} else if (!ValidationUtil.isEmpty(sjfz)) {
			jsonObject.put(XJConstant.INS_PRESON,sjfz);
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"设计负责人分配项目负责人");
		} else if (!ValidationUtil.isEmpty(sjzl)) {
			jsonObject.put(XJConstant.INS_PRESON,sjzl);
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"设计项目负责人分配资料员");
		} else if (!ValidationUtil.isEmpty(azfz)) {
			jsonObject.put(XJConstant.INS_PRESON,azfz);
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"安装负责人分配项目负责人");
		} else if (!ValidationUtil.isEmpty(azzl)) {
			jsonObject.put(XJConstant.INS_PRESON,azzl);
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"安装项目负责人分配资料员");
		}
		if("0".equals(option)){
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"审核不通过");
		}
		if(ValidationUtil.isEmpty(option)){
			option = json.getString(XJConstant.PROCESS_PROJECT_STATE);
			if("1".equals(option)){
				jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"资料审批通过");
			} else if ("0".equals(option)){
				jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"资料审批不通过");
			} else if ("3".equals(option)){
				jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"监检科室待分配");
				option = "1";
			} else if ("4".equals(option)){
				jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"资料审核不通过");
				option = "0";
			}
		}
		if(ValidationUtil.isEmpty(option)){
			option = "1";
		}
		if(!ObjectUtils.isEmpty(condition) && condition.equals("0")) {
			option = "0";
		}

		projectInitiationService.execute(project.getInstanceId(),jsonObject,option,null);
		return ResponseHelper.buildResponse("ok");
	}


	/**
	 * 审核员项目审核
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "审核员项目审核", notes = "审核员项目审核")
	@PostMapping(value = "/insProcess")
	public ResponseModel<String> insProcess(String sequenceNbr,@RequestBody JSONObject json){
		String option = json.getString(XJConstant.PROCESS_PROJECT_STATE);
		Project project = projectServiceImpl.getById(sequenceNbr);
		JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(project));
		jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"立项成功");
		if("0".equals(option)){
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"项目退回");
			projectInitiationService.execute(project.getInstanceId(),jsonObject,option,null);
			projectInitiationService.execute(project.getInstanceId(),jsonObject,option,null);
		}else if("2".equals(option)){
			jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,"项目需重新提交资料");
		}
		projectInitiationService.execute(project.getInstanceId(),jsonObject,option,null);
		return ResponseHelper.buildResponse("ok");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "添加附件", notes = "添加附件")
	@PostMapping(value = "/saveOrUpdateFile")
	public ResponseModel<String> saveOrUpdateFile(@RequestBody JSONObject jsonObject){
		String type = projectServiceImpl.saveOrUpdateFile(jsonObject);
		if ("over".equals(type)) {
			CommonResponseUtil.success(type,"提交成功！");
		} else if ("fail".equals(type)) {
			CommonResponseUtil.failure("资料尚未添加完成，不能提交！");
		} else {
			return CommonResponseUtil.success(type,"保存成功！");
		}
		return ResponseHelper.buildResponse(type);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "通过sequenceNbr查询项目详情", notes = "通过sequenceNbr查询项目详情")
	@GetMapping(value = "/getDetail")
	public ResponseModel<JSONObject> getDetail(Long sequenceNbr){
		JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(projectServiceImpl.getInformationDetail(sequenceNbr)));
		JSONObject jo = new JSONObject();
		jo.put("projectInfo",projectServiceImpl.selectById(sequenceNbr));
		jo.put("fileInfo",jsonObject);
		return ResponseHelper.buildResponse(jo);
	}


	/**
	 * 查询当前登陆的建设单位和组织机构代码
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询当前登陆的建设单位和组织机构代码", notes = "查询当前登陆的建设单位和组织机构代码")
	@GetMapping(value = "/getConstructionInfo")
	public ResponseModel <Map> getConstructionInfo(){
		return ResponseHelper.buildResponse(orgServiceImpl.getConstructionInfo());
	}


	/**
	 * 项目进度
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "项目进度", notes = "项目进度")
	@GetMapping(value = "/projectSchedule")
	public ResponseModel <List<Map<String,String>>> projectSchedule(){
		return ResponseHelper.buildResponse(projectServiceImpl.projectSchedule());
	}

	/**
	 * 项目进度
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "项目进度", notes = "项目进度")
	@GetMapping(value = "/getProjectNumber")
	public ResponseModel<Map> getProjectNumber(){
		Map<String, Integer> map = new HashMap<>();
		map.put("num",0);
		List<Project> projects = projectResourceServiceImpl.getProjectList();
		if(!ValidationUtil.isEmpty(projects)){
			map.put("num",projects.size());
		}
		return ResponseHelper.buildResponse(map);
	}


	/**
	 * 项目概况
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "项目概况", notes = "项目概况")
	@GetMapping(value = "/projectOverview")
	public ResponseModel<List<Map<String,String>>> projectOverview(){
		return ResponseHelper.buildResponse(projectServiceImpl.projectOverview());
	}

	/**
	 * 当前辖区的在建项目
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "当前辖区的在建项目", notes = "当前辖区的在建项目")
	@GetMapping(value = "/projectInProgress")
	public ResponseModel<JSONObject> projectInProgress(){
		return ResponseHelper.buildResponse(projectServiceImpl.projectInProgress());
	}

	/**
	 * 获取当前登陆人所在单位下的项目的项目信息（包含经纬度信息）
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "获取当前登陆人所在单位下的项目的项目信息（包含经纬度信息）", notes = "获取当前登陆人所在单位下的项目的项目信息（包含经纬度信息）")
	@GetMapping(value = "/getProjectLocation")
	public ResponseModel<List<ProjectDto>> getProjectLocation(){
		return ResponseHelper.buildResponse(projectServiceImpl.getProjectLocation());
	}

	/**
	 * 根据项目id获取项目详情（包含经纬度信息）
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "根据项目id获取项目详情（包含经纬度信息）", notes = "根据项目id获取项目详情（包含经纬度信息）")
	@GetMapping(value = "/getProjectLocationOne/{projectId}")
	public ResponseModel<ProjectDto> getProjectLocationOne(@PathVariable String projectId){
		return ResponseHelper.buildResponse(projectServiceImpl.getProjectLocationOne(projectId));
	}


	/**
	 * 资料详情
	 * @param sequenceNbr
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "资料详情", notes = "资料详情")
	@GetMapping(value = "/getInformationDetail")
	public ResponseModel<Object> getInformationDetail(@RequestParam("sequenceNbr") Long sequenceNbr){
		return ResponseHelper.buildResponse(projectServiceImpl.getInformationDetail(sequenceNbr));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "资料提交/保存", notes = "资料提交/保存")
	@PostMapping(value = "/informationSaveOrUpdate")
	public ResponseModel<Object> informationSaveOrUpdate(@RequestBody JSONObject jsonObject) {
		Map<String, Object> map = (Map<String, Object>) jsonObject.get(TabLogoEnum.项目资料信息.getLogo());
		InformationDto dto = new InformationDto();
		Long projectId = Long.valueOf(String.valueOf(jsonObject.get("projectId")));
		String type = String.valueOf(jsonObject.get("type"));
		List<Map<String, Object>> welderList = (List<Map<String, Object>>) map.get("welderList");
		if (!ObjectUtils.isEmpty(welderList)) {
			dto.setWelderList(welderList);
		}

		List<Map<String, Object>> materialList = (List<Map<String, Object>>) map.get("materialList");
		if (!ObjectUtils.isEmpty(materialList)) {
			dto.setMaterialList(materialList);
		}

		List<Map<String, Object>> equipmentList = (List<Map<String, Object>>) map.get("equipmentList");
		if (!ObjectUtils.isEmpty(equipmentList)) {
			dto.setEquipmentList(equipmentList);
		}

		dto.setType(String.valueOf(jsonObject.get("type")));
		JSONObject jsonObject2 = new JSONObject();
		jsonObject2.put("designSubForm", map.get("designSubForm"));
		jsonObject2.put("installSubForm", map.get("installSubForm"));
		projectServiceImpl.informationSaveOrUpdate(dto.getEquipmentList(), dto.getWelderList(), dto.getMaterialList(), jsonObject2, projectId, type);
		return ResponseHelper.buildResponse("ok");
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "资料保存、审核", notes = "资料保存、审核")
	@PostMapping(value = "/informationAudit")
	public ResponseModel<Object> informationAudit(@RequestBody JSONObject jsonObject) {
		Map<String, Object> map = (Map<String, Object>) jsonObject.get(TabLogoEnum.项目资料信息.getLogo());
		InformationDto dto = new InformationDto();
		dto.setProjectId(jsonObject.getLong("projectId"));
		dto.setWelderList(new ArrayList<>());
		dto.setMaterialList(new ArrayList<>());
		dto.setEquipmentList(new ArrayList<>());
		dto.setFileList(new ArrayList<>());
		List<Map<String, Object>> welderList = (List<Map<String, Object>>) map.get("welderList");
		if (!ObjectUtils.isEmpty(welderList)) {
			dto.setWelderList(welderList);
		}
		List<Map<String, Object>> materialList = (List<Map<String, Object>>) map.get("materialList");
		if (!ObjectUtils.isEmpty(materialList)) {
			dto.setMaterialList(materialList);
		}
		List<Map<String, Object>> equipmentList = (List<Map<String, Object>>) map.get("equipmentList");
		if (!ObjectUtils.isEmpty(equipmentList)) {
			dto.setEquipmentList(equipmentList);
		}
		List<Map<String, Object>> fileList = (List<Map<String, Object>>) map.get("fileList");
		if (!ObjectUtils.isEmpty(fileList)) {
			dto.setFileList(fileList);
		}
		projectServiceImpl.informationAudit(dto.getEquipmentList(), dto.getWelderList(), dto.getMaterialList(), dto.getFileList(), dto.getProjectId(), String.valueOf(jsonObject.get("type")));
		return ResponseHelper.buildResponse("ok");
	}

	/**
	 * 审核资料详情(安装和设计)
	 * @param projectId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "审核资料详情", notes = "审核资料详情")
	@GetMapping(value = "/getAuditInformationDetail")
	public ResponseModel<Object> getAuditInformationDetail(@RequestParam("projectId") Long projectId){
		// 前端定制组件格式
		Page<Map<String, Object>> mapPage = new Page<>();
		List<Map<String, Object>> auditInformationDetail = projectServiceImpl.getAuditInformationDetail(projectId);
		mapPage.setRecords(auditInformationDetail);
		return ResponseHelper.buildResponse(mapPage);
	}

	/**
	 * 审核资料详情（设计）
	 * @param projectId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "审核资料详情", notes = "审核资料详情")
	@GetMapping(value = "/getDesignDetail")
	public ResponseModel<Object> getDesignDetail(@RequestParam("projectId") Long projectId){
		// 前端定制组件格式
		Page<Map<String, Object>> mapPage = new Page<>();
		List<Map<String, Object>> auditInformationDetail = projectServiceImpl.getDesignDetail(projectId);
		mapPage.setRecords(auditInformationDetail);
		return ResponseHelper.buildResponse(mapPage);
	}

	/**
	 * 根据companyId查询企业下的人员列表
	 * @param companyId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "根据companyId查询企业下的人员列表", notes = "根据companyId查询企业下的人员列表")
	@GetMapping(value = "/getPersonByCompanyId")
	public ResponseModel<List<OrgUsr>> getPersonByCompanyId(String companyId){
		return ResponseHelper.buildResponse(orgServiceImpl.getPersonByCompanyId(companyId));
	}

	/**
	 * 获取当前登录人的单位类型
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "获取当前登录人的单位类型", notes = "获取当前登录人的单位类型")
	@GetMapping(value = "/companyType")
	@BusinessIdentify
	public ResponseModel<Map> getCompanyType(){
		Map<String,String> map = new HashMap<>();
		map.put("unitType",orgServiceImpl.getReginParams().getBusinessInfo().getCompanyType());
		return ResponseHelper.buildResponse(map);
	}

	/**
	 * 根据projectId查询 项目基本信息、资料信息、告知信息、竣工结项信息
	 * @param projectId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "根据projectId查询信息", notes = "根据projectId查询信息")
	@GetMapping(value = "/getProjectDetails")
	public ResponseModel<JSONObject> getProjectDetails(@RequestParam("projectId") Long projectId, @RequestParam(value = "type",required = false)String type){
		if(ValidationUtil.isEmpty(projectServiceImpl.getById(projectId))){
			InstallNotice installNotice = iInstallNoticeService.getById(projectId);
			if(!ValidationUtil.isEmpty(installNotice)){
				projectId = installNotice.getProjectId();
			}
		}
		JSONObject jsonObject = new JSONObject();
		//项目基本信息
		jsonObject.put(TabLogoEnum.项目基本信息.getLogo(),projectServiceImpl.selectById(projectId));
		//项目资料信息
		if (!ObjectUtils.isEmpty(type)){
			jsonObject.put(TabLogoEnum.项目资料信息.getLogo(),getStatus(projectId, type));
		}else {
			jsonObject.put(TabLogoEnum.项目资料信息.getLogo(),projectServiceImpl.getInformationDetail(projectId));
		}
		//项目告知信息
		jsonObject.put(TabLogoEnum.项目告知信息.getLogo(),iInstallNoticeService.getInfoByProjectId(projectId));
		//项目竣工信息
		jsonObject.put(TabLogoEnum.项目竣工信息.getLogo(), projectOverFlowService.selectOne(projectId));
		//项目流程跟踪
		jsonObject.put(TabLogoEnum.项目流程跟踪.getLogo(), iProcessRelationService.getProcessRelation(projectId));
		return ResponseHelper.buildResponse(jsonObject);
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "根据projectId查询信息", notes = "根据projectId查询信息")
	@GetMapping(value = "/auditMessage")
	public ResponseModel<JSONObject> aduitMessage(@RequestParam("projectId") Long projectId, @RequestParam("type") String type) {
		if (ValidationUtil.isEmpty(projectServiceImpl.getById(projectId))) {
			InstallNotice installNotice = iInstallNoticeService.getById(projectId);
			if (!ValidationUtil.isEmpty(installNotice)) {
				projectId = installNotice.getProjectId();
			}
		}
		JSONObject jsonObject = new JSONObject();

		jsonObject.put(TabLogoEnum.项目资料信息.getLogo(), getStatus(projectId, type));
		//项目基本信息
		jsonObject.put(TabLogoEnum.项目基本信息.getLogo(), projectServiceImpl.selectById(projectId));
		return ResponseHelper.buildResponse(jsonObject);
	}

	private FileDto getStatus(Long projectId, String type) {
		//项目资料信息
		FileDto informationDetail = projectServiceImpl.getInformationDetail(projectId);
		ProjectDto detail = projectMapper.getDetail(projectId);
		informationDetail.setProjectStatus(detail.getStatus());
		LambdaQueryWrapper<ProjectInitiation> lambda = new QueryWrapper<ProjectInitiation>().lambda();
		lambda.eq(ProjectInitiation::getInstanceId, detail.getInstanceId());
		lambda.orderByDesc(ProjectInitiation::getRecDate);
		ArrayList<String> azStatus = new ArrayList<>();
		ArrayList<String> sjStatus = new ArrayList<>();
		List<ProjectInitiation> projectInitiations = projectInitiationService.getBaseMapper().selectList(lambda);
		if (!ObjectUtils.isEmpty(projectInitiations)) {
			projectInitiations.forEach(item -> {
				JSONObject context = JSONObject.parseObject(item.getContext());
				if (!ObjectUtils.isEmpty(context) && !ObjectUtils.isEmpty(context.get("sj_status"))) {
					sjStatus.add(String.valueOf(context.get("sj_status")));
				}
				if (!ObjectUtils.isEmpty(context)  && !ObjectUtils.isEmpty(context.get("az_status"))) {
					azStatus.add(String.valueOf(context.get("az_status")));
				}
			});
			if ("design".equals(type) && !ObjectUtils.isEmpty(sjStatus)) {
				informationDetail.setRemark(sjStatus.get(0));
			}
			if ("install".equals(type) && !ObjectUtils.isEmpty(azStatus)) {
				informationDetail.setRemark(azStatus.get(0));
			}
		}
		return informationDetail;
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "资料部门审核、审批", notes = "资料部门审核、审批")
	@PostMapping(value = "/messageAudit")
	public ResponseModel<Object> informationSaveOrUpdate(@RequestParam("sequenceNbr") String sequenceNbr,@RequestParam("type") String type,@RequestBody JSONObject object ) throws ParseException {
		Project project = projectServiceImpl.getById(sequenceNbr);
		JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(project));
		JSONObject fileInfo = JSONObject.parseObject(JSON.toJSONString(object.get("fileInfo")));
		String status = String.valueOf(fileInfo.get("option"));
		if ("design".equals(type)){
			if ("1".equals(String.valueOf(fileInfo.get("option")))){
				jsonObject.put("sj_status", DateUtils.dateFormat(DateUtils.getDateNow(), DateUtils.DATE_TIME_PATTERN) +"    部门审核通过");
			}else {
				jsonObject.put("sj_status", DateUtils.dateFormat(DateUtils.getDateNow(), DateUtils.DATE_TIME_PATTERN) +"    部门审核驳回"+" 原因："+fileInfo.get("reason"));
			}
		}
		if ("install".equals(type)){
			if ("1".equals(String.valueOf(fileInfo.get("option")))){
				jsonObject.put("az_status", DateUtils.dateFormat(DateUtils.getDateNow(), DateUtils.DATE_TIME_PATTERN) +"    部门审核通过");
			}else {
				jsonObject.put("az_status", DateUtils.dateFormat(DateUtils.getDateNow(), DateUtils.DATE_TIME_PATTERN) +"    部门审核驳回"+" 原因："+fileInfo.get("reason"));
			}
		}

		projectInitiationService.execute(project.getInstanceId(),jsonObject,status,null);
		return ResponseHelper.buildResponse("ok");
	}
	/**
	 * 获取当前登录人下所在单位的项目总数
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "获取当前登录人下所在单位的项目总数", notes = "获取当前登录人下所在单位的项目总数")
	@GetMapping(value = "/getCountPorject")
	@BusinessIdentify
	public ResponseModel<JSONObject> getCountPorject(){
		LambdaQueryWrapper<Project> objectLambdaQueryWrapper = new LambdaQueryWrapper<>();
		ReginParams reginParams = orgServiceImpl.getReginParams();
		String companyType = reginParams.getBusinessInfo().getCompanyType();
		Long companySequenceNbr = reginParams.getBusinessInfo().getCompanySequenceNbr();
		if (OrgEnum.安装单位.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getInstallationUnitId,companySequenceNbr);
		} else if (OrgEnum.设计单位.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getDesignUnitId,companySequenceNbr);
		} else if (OrgEnum.建设单位.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getConstructionUnitId,companySequenceNbr);
		} else if (OrgEnum.监察部门.getKey().equals(companyType)) {
			//区域
			CompanyDto companyDto = companyServiceImpl.queryBySeq(companySequenceNbr);
			String regionCode = companyDto.getRegionCode();
			objectLambdaQueryWrapper.like(Project::getInstallRegionCode,regionCode);

		} else if (OrgEnum.监检机构.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getTestingUnitId,companySequenceNbr);
		} else if (OrgEnum.监理单位.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getSupervisionUnitId,companySequenceNbr);
		} else if (OrgEnum.建设单位负责人.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getChargePersonId,companySequenceNbr);
		}
		Integer count = projectServiceImpl.count(objectLambdaQueryWrapper);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("title",count);
		return ResponseHelper.buildResponse(jsonObject);
	}

	/**
	 * 获取当前登录人下所在单位的在建项目数量和项目长度
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "获取当前登录人下所在单位的在建项目数量和项目长度", notes = "获取当前登录人下所在单位的在建项目数量和项目长度")
	@GetMapping(value = "/getLenths")
	@BusinessIdentify
	public ResponseModel<JSONObject> getLenths(){
		Float lengths=0.00f;
		LambdaQueryWrapper<Project> objectLambdaQueryWrapper = new LambdaQueryWrapper<>();
		ReginParams reginParams = orgServiceImpl.getReginParams();
		String companyType = reginParams.getBusinessInfo().getCompanyType();
		Long companySequenceNbr = reginParams.getBusinessInfo().getCompanySequenceNbr();
		if (OrgEnum.安装单位.getKey().equals(companyType)) {
			objectLambdaQueryWrapper
					.eq(Project::getInstallationUnitId,companySequenceNbr).ne(Project::getStatus,"竣工流程结束!");
			for (Project project : projectMapper.selectList(objectLambdaQueryWrapper)) {
				lengths += Float.valueOf(project.getLength())   ;
			}


		} else if (OrgEnum.设计单位.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getDesignUnitId,companySequenceNbr).ne(Project::getStatus,"竣工流程结束!");
			for (Project project : projectMapper.selectList(objectLambdaQueryWrapper)) {
				lengths += Float.valueOf(project.getLength())   ;
			}
		} else if (OrgEnum.建设单位.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getConstructionUnitId,companySequenceNbr).ne(Project::getStatus,"竣工流程结束!");
			for (Project project : projectMapper.selectList(objectLambdaQueryWrapper)) {
				lengths += Float.valueOf(project.getLength())   ;
			}
		} else if (OrgEnum.监察部门.getKey().equals(companyType)) {
			//区域
			CompanyDto companyDto = companyServiceImpl.queryBySeq(companySequenceNbr);
			String regionCode = companyDto.getRegionCode();
			objectLambdaQueryWrapper.like(Project::getInstallRegionCode,regionCode).ne(Project::getStatus,"竣工流程结束!");
			for (Project project : projectMapper.selectList(objectLambdaQueryWrapper)) {
				lengths += Float.valueOf(project.getLength())   ;
			}

		} else if (OrgEnum.监检机构.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getTestingUnitId,companySequenceNbr).ne(Project::getStatus,"竣工流程结束!");
			for (Project project : projectMapper.selectList(objectLambdaQueryWrapper)) {
				lengths += Float.valueOf(project.getLength())   ;
			}

		} else if (OrgEnum.监理单位.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getSupervisionUnitId,companySequenceNbr).ne(Project::getStatus,"竣工流程结束!");
			for (Project project : projectMapper.selectList(objectLambdaQueryWrapper)) {
				lengths += Float.valueOf(project.getLength())   ;
			}
		} else if (OrgEnum.建设单位负责人.getKey().equals(companyType)) {
			objectLambdaQueryWrapper.eq(Project::getChargePersonId,companySequenceNbr).ne(Project::getStatus,"竣工流程结束!");
			for (Project project : projectMapper.selectList(objectLambdaQueryWrapper)) {
				lengths += Float.valueOf(project.getLength())   ;
			}
		}
		Integer count = projectServiceImpl.count(objectLambdaQueryWrapper);

		JSONObject jsonObject = new JSONObject();
		String[] split = lengths.toString().split(".");
		String s = "";
		if(split.length != 0) {
			s =split[0]+"Km";
		} else {
			s = "0Km";
		}

		jsonObject.put("number",count);
		jsonObject.put("lengths",s);
		return ResponseHelper.buildResponse(jsonObject);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "token", notes = "token")
	@GetMapping(value = "/getUserToken")
	public ResponseModel<ReginParams> getUserToken(){
		ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
		return ResponseHelper.buildResponse(reginParams);

	}

	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/getProject")
	@ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个项目信息表", notes = "根据sequenceNbr查询单个项目信息表")
	public ResponseModel<ProjectDto> getProject( Long sequenceNbr) {
		return ResponseHelper.buildResponse(projectServiceImpl.selectById(sequenceNbr));
	}

	/**
	 * 根据projectId查询 项目基本信息
	 * @param projectId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "Post", value = "根据projectId查询项目基本信息", notes = "根据projectId查询项目基本信息")
	@PostMapping(value = "/getFollow")
	public ResponseModel<Object> getFollow(@RequestParam("projectId") Long projectId){
		if(ValidationUtil.isEmpty(projectServiceImpl.getById(projectId))){
			InstallNotice installNotice = iInstallNoticeService.getById(projectId);
			if(!ValidationUtil.isEmpty(installNotice)){
				projectId = installNotice.getProjectId();
			}
		}
		//项目基本信息
		JSONObject jsonObject= (JSONObject)JSONObject.toJSON(projectServiceImpl.selectById(projectId));
		return ResponseHelper.buildResponse(jsonObject);
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "项目资源补充提交", notes = "项目资源补充提交")
	@PostMapping(value = "/projectResourceSubmit")
	public ResponseModel<Object> projectResourceSubmit(@RequestBody ProjectResourceAuditDto dto) {
		String instanceId = projectResourceMapper.selectInstanceId(dto.getProjectId(), dto.getType());
		if (!ObjectUtils.isEmpty(instanceId)) {
			LambdaQueryWrapper<ProjectResource> lambda = new QueryWrapper<ProjectResource>().lambda();
			lambda.eq(ProjectResource::getInstanceId, instanceId);
			List<ProjectResource> projectResources = projectResourceMapper.selectList(lambda);
			if (!ObjectUtils.isEmpty(projectResources.get(0)) && !ObjectUtils.isEmpty(projectResources.get(0).getAuditStatus()) && "资料提交".equals(projectResources.get(0).getAuditStatus())) {
				// 存在被驳回流程，直接执行
				projectInitiationService.projectResourceExecute(instanceId, null, dto.getType());
			} else {
				throw new BadRequest("存在未结束审核流程！");
			}
		} else {
			// 启动流程
			projectInitiationService.projectResourceStart(dto);
		}
		return ResponseHelper.buildResponse("ok");
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "POST", value = "项目资源补充审批执行", notes = "项目资源补充审批执行")
	@PostMapping(value = "/projectResourceExecute")
	public ResponseModel<Object> projectResourceExecute(@RequestBody ProjectResourceAuditDto dto) {
		String instanceId = projectResourceMapper.selectInstanceId(dto.getProjectId(), dto.getType());
		projectInitiationService.projectResourceExecute(instanceId, dto.getStatus(), dto.getType());
		return ResponseHelper.buildResponse("ok");
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@ApiOperation(httpMethod = "GET", value = "查询项目绑定资源信息", notes = "查询项目绑定资源信息")
	@GetMapping(value = "/getResourceByProjectId")
	public ResponseModel<Object> getResourceByProjectId(@RequestParam("pageNumber") Long pageNumber, @RequestParam("size") Long size, @RequestParam("projectId") Long projectId, @RequestParam("type") String type) {
		String columnKey = "column";
		String valueKey = "value";
		String sequenceNbrKey = "sequenceNbr";
		Page<Map<String, Object>> page = new Page<>(pageNumber, size);
		if ("welder".equals(type)) {
			Page<Map<String, Object>> welders = projectResourceMapper.getWelders(page, projectId);
			if (!ObjectUtils.isEmpty(welders.getRecords())) {
				welders.getRecords().forEach(item -> {
					List<Map<String, Object>> itemMessage = dynamicFormInstanceMapper.getMessageByInstanceId(String.valueOf(item.get(sequenceNbrKey)));
					itemMessage.forEach(dataItem -> {
//						if (String.valueOf(dataItem.get(columnKey)).equals("image") && !ObjectUtils.isEmpty(dataItem.get(columnKey)) && !ObjectUtils.isEmpty(dataItem.get(valueKey))) {
//							String value1 = String.valueOf(dataItem.get(valueKey));
//							List<Map<String, Object>> imageMap = (List<Map<String, Object>>) JSON.parse(value1);
//							if (!ObjectUtils.isEmpty(imageMap)) {
//								item.put("files", imageMap);
//							}
//						}else {
						item.put(String.valueOf(dataItem.get(columnKey)), dataItem.get(valueKey));
//						}
					});
				});
			}
			return ResponseHelper.buildResponse(welders);
		} else if ("equipment".equals(type)) {
			Page<Map<String, Object>> equipments = projectResourceMapper.getEquipments(page, projectId);
			return ResponseHelper.buildResponse(equipments);
		} else if ("material".equals(type)) {
			Page<Map<String, Object>> materials = projectResourceMapper.getMaterials(page, projectId);
			return ResponseHelper.buildResponse(materials);
		}
		return ResponseHelper.buildResponse(null);
	}

	/**
	 * 根据角色获取平台用户
	 * @param roleId 角色id
	 * @return 用户
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/queryUserByRoleId")
	@BusinessIdentify
	@ApiOperation(httpMethod = "GET",value = "查询登陆人所在公司的某个角色的人",  notes = "查询登陆人所在公司的某个角色的人")
	public ResponseModel<List<Map<String, String>>> queryUserByRoleId(String roleId) {
		AgencyUserModel userInfo = getUserInfo();
		List<CompanyModel> companys = userInfo.getCompanys();
		return ResponseHelper.buildResponse(projectServiceImpl.queryUserByRoleId(roleId, companys));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
	@GetMapping(value = "/getProjectWeld")
	@ApiOperation(httpMethod = "get", value = "项目和焊口信息", notes = "项目和焊口信息")
	public ResponseModel<Map<String,Object>> getProjectWeld(@RequestParam("projectId") String projectId){
		return ResponseHelper.buildResponse(projectServiceImpl.getProjectWeld(projectId));
	}

}

