package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.ugp.api.Enum.ProjectInitiationEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectMaterialDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.WelderEquipmentDto;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.module.ugp.api.entity.Equipment;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import com.yeejoin.amos.boot.module.ugp.api.mapper.EquipmentMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectResourceMapper;
import com.yeejoin.amos.boot.module.ugp.biz.service.impl.MaterialServiceImpl;
import org.aspectj.bridge.Message;
import org.springframework.validation.ValidationUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.ugp.biz.service.impl.ProjectResourceServiceImpl;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.ValidationEvent;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectResourceDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 项目资源表（包括焊工、管材、设备）
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "项目资源表（包括焊工、管材、设备）Api")
@RequestMapping(value = "/project-resource")
public class ProjectResourceController extends BaseController {

    @Autowired
    ProjectResourceServiceImpl projectResourceServiceImpl;

    @Autowired
    ProjectResourceMapper projectResourceMapper;
    @Autowired
    MaterialServiceImpl materialServiceImpl;

    /**
     * 新增项目资源表（包括焊工、管材、设备）
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增项目资源表（包括焊工、管材、设备）", notes = "新增项目资源表（包括焊工、管材、设备）")
    public ResponseModel<ProjectResourceDto> save(@RequestBody ProjectResourceDto model) {
        model = projectResourceServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新项目资源表（包括焊工、管材、设备）", notes = "根据sequenceNbr更新项目资源表（包括焊工、管材、设备）")
    public ResponseModel<ProjectResourceDto> updateBySequenceNbrProjectResource(@RequestBody ProjectResourceDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(projectResourceServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除项目资源表（包括焊工、管材、设备）", notes = "根据sequenceNbr删除项目资源表（包括焊工、管材、设备）")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        LambdaQueryWrapper<ProjectResource> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectResource::getResourceId,sequenceNbr);
        ProjectResource projectResource = projectResourceMapper.selectOne(wrapper);

        return ResponseHelper.buildResponse(projectResourceServiceImpl.deleteBySeq(projectResource.getSequenceNbr()));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询焊机设备）", notes = "根据sequenceNbr查询焊机设备")
    public ResponseModel<WelderEquipmentDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(projectResourceServiceImpl.customSelectById(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "项目资源表（包括焊工、管材、设备）分页查询", notes = "项目资源表（包括焊工、管材、设备）分页查询")
    public ResponseModel<Page<ProjectResourceDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<ProjectResourceDto> page = new Page<ProjectResourceDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(projectResourceServiceImpl.queryForProjectResourcePage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "项目资源表（包括焊工、管材、设备）列表全部数据查询", notes = "项目资源表（包括焊工、管材、设备）列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<ProjectResourceDto>> selectForList() {
        return ResponseHelper.buildResponse(projectResourceServiceImpl.queryForProjectResourceList());
    }

    /**
     * 焊机设备列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/welderpage")
    @ApiOperation(httpMethod = "GET", value = "焊机设备分页查询", notes = "焊机设备分页查询")
    public ResponseModel<Page<WelderEquipmentDto>> queryForPage11(
    		@RequestParam(value = "current") int current,
			@RequestParam(value = "size") int size,
			@RequestParam(value = "name", required = false) String name,
			@RequestParam(value = "type", required = false) String type
	) {
        Page<WelderEquipmentDto> page = new Page<WelderEquipmentDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(projectResourceServiceImpl.installNoticeMsgList(page, name, type));
    }

    @TycloudOperation(ApiLevel =  UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectByName")
    @ApiOperation(httpMethod = "GET", value = "焊机设备分页查询", notes = "焊机设备分页查询")
    public ResponseModel<WelderEquipmentDto> selectByName(Long sequenceNbr){
        return ResponseHelper.buildResponse(projectResourceServiceImpl.selectByName(sequenceNbr));
    }

    /**
     * 项目设备新增
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/welderSave")
    @ApiOperation(httpMethod = "POST", value = "项目设备新增", notes = "项目设备新增")
    public ResponseModel<Boolean> welderSave(@RequestBody WelderEquipmentDto welderEquipmentDto){
        this.projectResourceServiceImpl.welderSave(welderEquipmentDto);
        return ResponseHelper.buildResponse(true);
    }

    /**
     * 项目设备删除
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @DeleteMapping(value = "/welderDelete")
    @ApiOperation(httpMethod = "Delete", value = "项目设备删除", notes = "项目设备删除")
    public ResponseModel<Boolean> welderDelete(
            @RequestParam Long ids
    ){
        LambdaQueryWrapper<ProjectResource> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectResource::getResourceId,ids);
         projectResourceMapper.delete(wrapper);

        return ResponseHelper.buildResponse(true);
    }

	/**
	 * 绑定项目所用到的设备管材
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "POST",value = "绑定项目所用到的设备管材",   notes = "绑定项目所用到的设备管材")
	@PostMapping(value = "/saveId")
	public ResponseModel saveId(@RequestBody JSONObject jsonObject) throws Exception {
        ResponseModel responseModel = projectResourceServiceImpl.saveIds(jsonObject);

        return responseModel;

	}



    /**
     * 根据项目id获取项目使用到的设备
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/projectEquipment")
    @ApiOperation(httpMethod = "GET" ,value = "根据项目id获取项目使用到的设备" , notes = "根据项目id获取项目使用到的设备")
    public ResponseModel<List<JSONObject>> projectEquipment(@RequestParam String projectId){
        return ResponseHelper.buildResponse(projectResourceServiceImpl.getProjectEquipment(projectId));

    }

    /**
     * 根据项目ID获取项目使用到的管材
     * @param projectId
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/projectMaterial")
    @ApiOperation( httpMethod = "GET",value = "根据项目ID获取项目使用到的管材", notes = "根据项目ID获取项目使用到的管材")
    public ResponseModel<List<JSONObject>> projectMaterial(@RequestParam String projectId){
        return ResponseHelper.buildResponse(projectResourceServiceImpl.getProjectMaterial(projectId));
    }


    /**
     * 项目管材分页列表，根据名称、编号查询
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/materialPage")
    @ApiOperation(httpMethod = "GET", value = "焊机设备分页查询", notes = "焊机设备分页查询")
    public ResponseModel<Page<ProjectMaterialDto>> queryForMaterialPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "code", required = false) String code
    ) {
        Page<ProjectMaterialDto> page = new Page<ProjectMaterialDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(projectResourceMapper.MaterialPage(page,name,code));
    }

    /**
     * 根据sequenceNbr查询项目材料
     *
     * @param sequenceNbr  主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "IM/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询材料和附件",  notes = "根据sequenceNbr查询材料和附件")
    public ResponseModel<JSONObject> selectIMOne(@PathVariable Long sequenceNbr) {
        JSONObject jsonObject = materialServiceImpl.groupBySeq(sequenceNbr);
        jsonObject.getLong("sequenceNbr");
        return ResponseHelper.buildResponse(materialServiceImpl.groupBySeq(sequenceNbr));
    }

    /**
     * 根据type获取当前登录所在单位下的项目中的所有资源列表
     * type:welder(焊工)、equipment（设备）、material（管材）
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PostMapping(value = "/getResourceInfo")
    @ApiOperation(httpMethod = "POST",value = "根据type获取当前登录所在单位下的项目中的所有资源列表",  notes = "根据type获取当前登录所在单位下的项目中的所有资源列表")
    public ResponseModel<IPage> getResourceInfo(@RequestParam(required = false) Long current,@RequestParam(required = false) Long size,String type,@RequestBody(required = false) ProjectResourceDto projectResourceinfo){
        if(ValidationUtil.isEmpty(size)){
            size = Long.MAX_VALUE;
        }
        if(ValidationUtil.isEmpty(current)){
            current = 0L;
        }
        IPage page = new Page();
        page.setSize(size);
        page.setCurrent(current);
        return ResponseHelper.buildResponse(projectResourceServiceImpl.getResourceInfo(type,page,projectResourceinfo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectByUserId")
    @ApiOperation(httpMethod = "get",value = "根据当前登录人获取登录人参与的项目列表",  notes = "根据当前登录人获取登录人参与的项目列表")
    public ResponseModel<List<Project>> selectByUserId(){
        List<Project> projectList = projectResourceServiceImpl.getProjectList();
        projectList = projectList.stream().filter(r -> !"竣工流程结束！".equals(r.getStatus())).collect(Collectors.toList());
        return ResponseHelper.buildResponse(projectList);
    }
}
