package com.yeejoin.amos.boot.module.ugp.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.WeldVerifyDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectResource;
import com.yeejoin.amos.boot.module.ugp.api.entity.Weld;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectResourceMapper;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.yeejoin.amos.boot.module.ugp.biz.service.impl.WeldServiceImpl;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ugp.api.dto.WeldDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 焊口信息表
 *
 * @author system_generator
 * @date 2022-09-22
 */
@RestController
@Api(tags = "焊口信息表Api")
@RequestMapping(value = "/weld")
public class WeldController extends BaseController {

    @Autowired
    WeldServiceImpl weldServiceImpl;
    @Autowired
    ProjectResourceMapper projectResourceMapper;

    /**
     * 新增焊口信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增焊口信息表", notes = "新增焊口信息表")
    public ResponseModel<WeldDto> save(@RequestBody WeldDto model) {
        model = weldServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新焊口信息表", notes = "根据sequenceNbr更新焊口信息表")
    public ResponseModel<WeldDto> updateBySequenceNbrWeld(@RequestBody WeldDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(weldServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除焊口信息表", notes = "根据sequenceNbr删除焊口信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") List<Long> sequenceNbr) throws Exception {
        LambdaQueryWrapper<ProjectResource> wrapper = new LambdaQueryWrapper<>();
        for (Long i:sequenceNbr){
            wrapper.eq(ProjectResource::getResourceId,i);
            if (!projectResourceMapper.selectList(wrapper).isEmpty()){
                throw  new Exception("无法删除，已绑定项目");
            }
        }
        return ResponseHelper.buildResponse(weldServiceImpl.removeByIds(sequenceNbr));

    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个焊口信息表", notes = "根据sequenceNbr查询单个焊口信息表")
    public ResponseModel<WeldDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(weldServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询+条件查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "Post", value = "焊口信息表分页查询", notes = "焊口信息表分页查询")
    public ResponseModel<IPage<WeldDto>> queryForPage(@RequestParam(value = "current") int current,
                                                      @RequestParam(value = "size") int size,
                                                      @RequestBody(required = false) WeldDto weldDto) {
        return ResponseHelper.buildResponse(weldServiceImpl.queryForWeldPage(current, size,weldDto));
    }

    /**
     * 根据焊口编码获取焊口信息
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getWeldInfo")
    @ApiOperation(httpMethod = "GET", value = "根据焊口编码获取焊口信息" , notes = "根据焊口编码获取焊口信息")
    public ResponseModel<Weld> getWeldInfo(@RequestParam String code){

        return ResponseHelper.buildResponse(weldServiceImpl.getWeldInfo(code));
    }

    /**
     * 更新焊口编码任务状态
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/updateTask")
    @ApiOperation(httpMethod = "GET", value = "更新焊口编码任务状态", notes = "更新焊口编码任务状态")
    public ResponseModel<String> updateTask(Weld weld) {

        return ResponseHelper.buildResponse(weldServiceImpl.updateTask(weld));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "焊口信息表列表全部数据查询", notes = "焊口信息表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<WeldDto>> selectForList() {
        return ResponseHelper.buildResponse(weldServiceImpl.queryForWeldList());
    }

    /**
     * 生成焊口编码
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "生成焊口编码", notes = "生成焊口编码")
    @GetMapping(value = "/getCode")
    public ResponseModel<List<Weld>> getCode(Long sequenceNbr, int number) {

        return ResponseHelper.buildResponse(weldServiceImpl.getCode(sequenceNbr,number));
    }

    /**
     * 通过项目id获取焊口编码
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "查看焊口编码", notes = "查看焊口编码")
    @GetMapping(value = "/lookCode")
    public ResponseModel<IPage<Weld>> lookCode(long current,long size,String projectId, WeldDto weldDto) {
        return ResponseHelper.buildResponse(weldServiceImpl.lookCode(current,size,projectId,weldDto));
    }

    /**
     * 通过项目id获取焊口编码
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "查看焊口编码", notes = "查看焊口编码")
    @GetMapping(value = "/weldInfos")
    public ResponseModel<IPage<WeldDto>> getWeldInfoByProjectId(long current,long size,String projectId, WeldDto weldDto) {
        IPage<WeldDto> weldInfoByProjectId = weldServiceImpl.getWeldInfoByProjectId(current, size, projectId, weldDto);
        if (!ValidationUtil.isEmpty(weldDto) &&  !ValidationUtil.isEmpty(weldDto.getStr()) && weldDto.getStr() == 1) {
            List<WeldDto> collect = weldInfoByProjectId.getRecords().stream().filter(t -> t.getStatus() == 1).collect(Collectors.toList());
            weldInfoByProjectId.setRecords(collect);
            int totals=0;
            if (!ValidationUtil.isEmpty(collect)) {
                totals=collect.size();
            }
            weldInfoByProjectId.setTotal(totals);
        }
        return ResponseHelper.buildResponse(weldInfoByProjectId);
    }

    /**
     * 通过项目id获取焊口智能监验信息

     */

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "焊口智能监验信息", notes = "焊口智能监验信息")
    @GetMapping(value = "/selectStatus")
    public ResponseModel<WeldVerifyDto> selectStage(Long projectId,String code) {
        return ResponseHelper.buildResponse(weldServiceImpl.selectStatus(projectId,code));
    }

    /**
     *      检验责任单位及监检状态
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "GET", value = "检验责任单位", notes = "检验责任单位")
    @GetMapping(value = "/selectDept")
    public ResponseModel<WeldDto> selectDept(String projectId){
        return ResponseHelper.buildResponse(weldServiceImpl.selectDept(projectId));
    }

    /**
     * 通过焊口码生成二维码接口
     * @return 二维码url地址
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getWeldQRCode")
    @ApiOperation(httpMethod = "GET", value = "通过焊口码生成二维码接口", notes = "通过焊口码生成二维码接口")
    public ResponseModel<IPage> getWeldQRCode(String HKCode){
        return ResponseHelper.buildResponse(weldServiceImpl.getWeldQRCode(HKCode));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getWeldList/{projectId}")
    @ApiOperation(httpMethod = "GET", value = "获取焊口定位信息", notes = "获取焊口定位信息")
    public ResponseModel<List<Weld>> getWeldList(@PathVariable( value = "projectId")String projectId,boolean isCraft){
        List<Weld> weldList = weldServiceImpl.list(new LambdaQueryWrapper<Weld>().eq(Weld::getProjectId,projectId));
        if(!isCraft){
            if(!ValidationUtil.isEmpty(weldList)){
                for(Weld weld : weldList){
                    weld.setLongitude(weld.getVoltageLongitude());
                    weld.setLatitude(weld.getVoltageLatitude());
                }
            }
        }

        return ResponseHelper.buildResponse(weldList);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getWeld")
    @ApiOperation(httpMethod = "GET", value = "获取焊口定位信息", notes = "获取焊口定位信息")
    public ResponseModel<List<Weld>> getWeld(@RequestParam( value = "region",required = false )String region){
        return ResponseHelper.buildResponse(weldServiceImpl.list());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @GetMapping(value = "/getWeldCode/{projectId}")
    @ApiOperation(httpMethod = "GET", value = "获取焊口定位信息List(只有经纬度信息)", notes = "获取焊口定位信息List(只有经纬度信息)")
    public ResponseModel<List<List<Double>>> getWeldCode(@PathVariable String projectId,boolean isCraft){
        return ResponseHelper.buildResponse(weldServiceImpl.getWeldCode(projectId,isCraft));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/getWeldListByLocation")
    @ApiOperation(httpMethod = "POST", value = "", notes = "")
    public ResponseModel<List<ProjectDto>> getWeldListByLocation(@RequestBody Object obj,boolean isCraft){
        return ResponseHelper.buildResponse(weldServiceImpl.getWeldListByLocation(obj,isCraft));
    }
    /**焊口切除更新*/
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/updateWeldRepairMark")
    @ApiOperation(httpMethod = "POST", value = "焊口切除更新", notes = "焊口切除更新")
    public ResponseModel<List<Map<String, String>>> updateWeldRepairMark(@RequestParam("projectId") String projectId,  @RequestBody List<String> weldCode){
        return ResponseHelper.buildResponse(weldServiceImpl.updateWeldRepairMark(projectId,weldCode));
    }

    /**焊口修复更新*/
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @PostMapping(value = "/updateWeldes")
    @ApiOperation(httpMethod = "POST", value = "焊口修复更新", notes = "焊口修复更新")
    public ResponseModel<String> updateWeldes(@RequestParam("projectId") String projectId,     @RequestBody JSONObject obj){
        return ResponseHelper.buildResponse(weldServiceImpl.updateWeldes(projectId,obj));
    }






}
