package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.ugp.api.Enum.ProcessTypeEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProcessRelationDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProcessRelation;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProcessRelationMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IProcessRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ProcessRelationServiceImpl extends BaseService<ProcessRelationDto, ProcessRelation, ProcessRelationMapper> implements IProcessRelationService {


    @Autowired
    ProjectInitiationServiceImpl projectInitiationService;

    @Autowired
    ProcessRelationMapper processRelationMapper;

    //项目立项流程编码
    static final String projectApproval = "projectApproval";
    //项目结项流程编码
    static final String projectClosing = "projectClosing";

    /**
     * 保存资源流程关系信息
     *
     * @param instanceId 流程实例id
     * @param sourceId 资源id
     * @param processName 流程名称（文字）
     */
    @Override
    public void savePR(String instanceId, Long sourceId, String processName){
        //此处不给state赋值，待流程执行更新state字段
        ProcessRelation processRelation = new ProcessRelation();
        processRelation.setInstanceId(instanceId);
        processRelation.setSourceId(sourceId);
        processRelation.setDefName(processName);
        processRelation.setDefCode(ProcessTypeEnum.getCodeByName.get(processName));
        this.save(processRelation);
    }

    /**
     * 更新资源流程关系信息 state字段
     *
     * @param instanceId 流程实例id
     * @Param taskName 任务节点名称，可为null
     */
    @Override
    public void updateState(String instanceId,String taskName){
        LambdaQueryWrapper<ProcessRelation> wrapper = new LambdaQueryWrapper();
        wrapper.eq(ProcessRelation::getInstanceId,instanceId);
        ProcessRelation processRelation = this.getOne(wrapper);
        try {
            if(ValidationUtil.isEmpty(taskName)) {
                taskName = projectInitiationService.getFlowTaskName(null,null,false,null,null,null,null,null,null,instanceId);
            }
            processRelation.setStatus(taskName);
            this.updateById(processRelation);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 根据projectId查询流程id
     * @param projectId
     * @return
     */
    @Override
    public Map<String, Object> getProcessRelation(Long projectId) {
        Map<String, Object> resultMap = new HashMap<>();
        List<Map<String, Object>> mapList = processRelationMapper.selectInstanceIdBySourceId(projectId);
        if(!ObjectUtils.isEmpty(mapList)){
            for (Map<String, Object> map : mapList) {
                if(projectApproval.equals(map.get("def_code"))){
                    resultMap.put(projectApproval,map.get("instance_id"));
                }
                if(projectClosing.equals(map.get("def_code"))){
                    resultMap.put(projectClosing,map.get("instance_id"));
                }
            }
            return resultMap;
        } else {
            return null;
        }
    }

}
