package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.ugp.api.Enum.*;
import com.yeejoin.amos.boot.module.ugp.api.dto.TaskDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.*;
import com.yeejoin.amos.boot.module.ugp.api.mapper.TaskMapper;
import com.yeejoin.amos.boot.module.ugp.api.mapper.TzUgpPathMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.TaskService;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;

/**
 * 监检任务表 服务实现类
 *
 * @author duanwei
 * @date 2022-10-19
 */
@Service
public class TaskServiceImpl extends BaseService<TaskDto, Task, TaskMapper> implements TaskService {

    @Autowired
    OrgServiceImpl orgService;

    @Autowired
    ProjectResourceServiceImpl projectResourceService;

    @Autowired
    QualityProblemServiceImpl qualityProblemService;

    @Autowired
    SuperviseRuleServiceImpl superviseRuleService;

    @Autowired
    CompanyServiceImpl companyService;

    @Autowired
    ProjectInitiationServiceImpl projectInitiationService;

    @Autowired
    TzUgpPathMapper tzUgpPathMapper;

    /**
     * 项目流程新增、更新任务表信息
     * @param InitiationStatus 项目/问题处置 表中的 status字段
     * @param taskType 任务类型（填报、流程）
     * @param sendTime
     * @Param sequenceNbr 项目/问题处置的sequenceNbr
     * @return
     */
    public void saveOrUpdateTask(String InitiationStatus, boolean status, String taskType, Date sendTime, Long sourceId, String type, List<Long> unitIds,Long extendId, String instanceId) {
        if (!ValidationUtil.isEmpty(unitIds)) {
            for (Long unitId : unitIds) {
                Task task = new Task();
                String title = "", taskStatus = "";
                task.setTaskType(taskType);
                if (!ValidationUtil.isEmpty(InitiationStatus)) {
                    //特殊处理
                    if (ProjectInitiationEnum.安装开工资料修改.getTaskName().equals(InitiationStatus)) { InitiationStatus = ProjectInitiationEnum.安装开工资料修改.getName(); }
                    if (ProjectInitiationEnum.设计开工资料修改.getTaskName().equals(InitiationStatus)) { InitiationStatus = ProjectInitiationEnum.设计开工资料修改.getName(); }

                    title = ProjectInitiationEnum.getTaskNameMap.get(InitiationStatus);
                    taskStatus = ProjectInitiationEnum.getTaskStatusMap.get(InitiationStatus);
                    if (ValidationUtil.isEmpty(title)) {
                        //不是项目立项流程，是问题处置流程
                        title = ProblemProcessEnum.getTaskNameMap.get(InitiationStatus);
                        taskStatus = ProblemProcessEnum.getTaskStatusMap.get(InitiationStatus);
                        if (ValidationUtil.isEmpty(title)) {
                            //不是以上流程、是项目结项流程
                            title = OverProjectFlowEnum.getTaskNameMap.get(InitiationStatus);
                            taskStatus = OverProjectFlowEnum.getTaskStatusMap.get(InitiationStatus);
                        }
                    }
                }

                if (InitiationStatus.contains(ProjectInitiationEnum.设计资料审核.getName()) || InitiationStatus.contains(ProjectInitiationEnum.设计资料审批.getName())){
                    // 部门内资料审核
                    if (status){
                        taskStatus = CompanyExamineEnum.部门审核.getYes();
                    }else {
                        taskStatus = CompanyExamineEnum.部门审核.getNo();
                    }
                }

                if (InitiationStatus.contains(ProjectInitiationEnum.安装资料审核.getName()) || InitiationStatus.contains(ProjectInitiationEnum.安装资料审批.getName())){
                    // 部门内资料审核
                    if (status){
                        taskStatus = CompanyExamineEnum.部门审核.getYes();
                    }else {
                        taskStatus = CompanyExamineEnum.部门审核.getNo();
                    }
                }

                if (ValidationUtil.isEmpty(title)) {
                    //不是问题处置流程，企业注册任务
                    title = CompanyExamineEnum.企业审核.getName();
                    if (status) {
                        taskStatus = CompanyExamineEnum.企业审核.getYes();
                    } else {
                        taskStatus = CompanyExamineEnum.企业审核.getNo();
                    }
                }

                if (TaskTypeEnum.填报.getKey().equals(taskType)) {
                    task.setTaskTypeLabel(TaskTypeEnum.填报.getName());
                } else if (TaskTypeEnum.流程.getKey().equals(taskType)) {
                    task.setTaskTypeLabel(TaskTypeEnum.流程.getName());
                } else {
                    task.setTaskTypeLabel(TaskTypeEnum.企业审核.getName());
                }

                int state;
                if(status){
                    state = 1;
                } else {
                    state = 0;
                }

                task.setUnitId(unitId);
                task.setTitle(title);
                task.setStatus(state);
                task.setSendTime(sendTime);
                task.setSourceId(sourceId);
                task.setType(type);
                task.setExtendId(extendId);

                if (status) {
                    //更新任务表 已办
                    LambdaQueryWrapper<Task> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(Task::getType, type)
                            .eq(Task::getStatus, 0)
                            .eq(Task::getTitle, title)
                            .eq(Task::getSourceId, sourceId)
                            .eq(Task::getUnitId, unitId);
                    List<Task> taskList = this.list(wrapper);
                    if (ValidationUtil.isEmpty(taskList)) {
                        return;
                    }
                    task = taskList.iterator().next();
                    task.setStatusLabel(TaskTypeEnum.已办.getName());
                    task.setStatus(state);
                    task.setExtendId(extendId);
                    taskStatus = "已完成";
                } else {
                    //添加任务表 待办
                    task.setStatusLabel(TaskTypeEnum.待办.getName());
                }
                task.setContent(title + ", " + taskStatus);
                task.setInstanceId(instanceId);
                List<String> roleList = getRoleList(instanceId, InitiationStatus);
                if (!ObjectUtils.isEmpty(roleList)) {
                    String join = String.join(",", roleList);
                    task.setRoleIds(join);
                }

                this.saveOrUpdate(task);
            }
        }
    }

    public void saveTaskMessage(Long sourceId, Long unitId, String instanceId, String title) {
        updateStatusTask(instanceId);
        if (!"流程结束！".equals(title)) {
            Task task = new Task();
            task.setSourceId(sourceId);
            task.setUnitId(unitId);
            task.setContent("");
            task.setStatus(0);
            task.setStatusLabel(TaskTypeEnum.待办.getName());
            task.setTaskType(TaskTypeEnum.流程.getKey());
            task.setTaskTypeLabel(TaskTypeEnum.流程.getName());
            task.setInstanceId(instanceId);
            task.setSendTime(DateUtils.getDateNow());
            task.setType(TaskTypeEnum.项目资料补充.getKey());
            task.setTitle(title);
            task.setContent(title + ", 待审批");
            List<String> roleList = getRoleList(instanceId, "");
            if (!ObjectUtils.isEmpty(roleList)) {
                String join = String.join(",", roleList);
                task.setRoleIds(join);
            }
            this.save(task);
        }

    }

    public List<String> getRoleList(String instanceId,String processName) {
        ArrayList<String> roleIds = new ArrayList<>();
        try {
//            AjaxResult ajaxResult = Workflow.taskClient.getTask(instanceId);
//            JSONObject data = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));

            JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(Workflow.taskClient.getTasksForDisposal(instanceId)));
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            if(jsonArray.size() > 1) {
                for(Object o:jsonArray){
                    String name = JSON.parseObject(JSON.toJSONString(o)).getString("name");
                    if(processName.equals(name)){
                        AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(String.valueOf(JSON.parseObject(JSON.toJSONString(o)).getString("id")));
                        if (!ObjectUtils.isEmpty(taskGroupName)) {
                            JSONArray data2 = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                            if (!ObjectUtils.isEmpty(data2)) {
                                data2.forEach(item -> {
                                    Map item1 = (Map) item;
                                    roleIds.add(String.valueOf(item1.get("groupId")));
                                });
                            }
                        }
                    }
                }
            } else if(jsonArray.size() == 1) {
                AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(String.valueOf(JSON.parseObject(JSON.toJSONString(jsonArray.get(0))).getString("id")));
                if (!ObjectUtils.isEmpty(taskGroupName)) {
                    JSONArray data2 = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
                    if (!ObjectUtils.isEmpty(data2)) {
                        data2.forEach(item -> {
                            Map item1 = (Map) item;
                            roleIds.add(String.valueOf(item1.get("groupId")));
                        });
                    }
                }
            }
        } catch (Exception e) {
            log.error("当前流程下一节点为空");
        }
        return roleIds;
    }

    private void updateStatusTask(String instanceId) {
        LambdaQueryWrapper<Task> lambda = new QueryWrapper<Task>().lambda();
        lambda.eq(Task::getInstanceId, instanceId);
        lambda.eq(Task::getStatus, 0);
        List<Task> tasks = this.getBaseMapper().selectList(lambda);
        if (!ObjectUtils.isEmpty(tasks)) {
            tasks.forEach(item -> {
                item.setStatus(1);
                item.setStatusLabel(TaskTypeEnum.已办.getName());
                item.setContent(item.getTitle() + ", 已完成");
            });
            this.saveOrUpdateBatch(tasks);
        }

    }

    public boolean findTheTask(String instanceId, String title) {
        LambdaQueryWrapper<Task> lambda = new QueryWrapper<Task>().lambda();
        lambda.eq(Task::getInstanceId, instanceId);
        lambda.eq(Task::getTitle, title);
        List<Task> tasks = this.getBaseMapper().selectList(lambda);
        if (!ObjectUtils.isEmpty(tasks)) {
            return true;
        } else {
            return false;
        }
    }

}
