package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.metadata.BaseRowModel;
import com.yeejoin.amos.boot.module.common.api.excel.ExplicitConstraint;
import com.yeejoin.amos.boot.module.common.api.excel.CommonExplicitConstraint;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class AircraftDtos extends BaseRowModel {
    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    @ExcelProperty(value = "飞机型号", index = 0)
    @ApiModelProperty(value = "飞机型号")
    private String aircraftModel;

    @ExcelProperty(value = "中文全称", index = 1)
    @ApiModelProperty(value = "中文全称")
    private String fullName;

    @ExcelProperty(value = "飞机长度", index = 2)
    @ApiModelProperty(value = "飞机长度")
    private Double aircraftLength;

    @ExcelProperty(value = "机舱长度", index = 3)
    @ApiModelProperty(value = "机舱长度")
    private Double cabinLength;

    @ExcelProperty(value = "尾翼高度", index = 4)
    @ApiModelProperty(value = "尾翼高度")
    private Double tailHeight;

    @ExcelProperty(value = "翼展", index = 5)
    @ApiModelProperty(value = "翼展")
    private Double wingspan;

    @ExcelProperty(value = "机身直径", index = 6)
    @ApiModelProperty(value = "机身直径")
    private Double fuselageDiameter;

    @ExcelProperty(value = "翼展面积", index = 7)
    @ApiModelProperty(value = "翼展面积")
    private Double wingspanArea;

    @ExplicitConstraint(type = "FDJLX", indexNum = 8, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "发动机类型", index = 8)
    @ApiModelProperty(value = "发动机类型")
    private String engineType;

    @ExcelIgnore
    @ApiModelProperty(value = "发动机类型code")
    private String engineTypeCode;

    @ExcelProperty(value = "发动机数量", index = 9)
    @ApiModelProperty(value = "发动机数量")
    private Integer enginesmNum;

    @ExcelProperty(value = "发动机型号", index = 10)
    @ApiModelProperty(value = "发动机型号")
    private String engineModel;

    @ExplicitConstraint(type = "RYLX", indexNum = 11, sourceClass = CommonExplicitConstraint.class) //动态下拉内容
    @ExcelProperty(value = "燃油类型", index = 11)
    @ApiModelProperty(value = "燃油类型")
    private String fuelType;

    @ExcelIgnore
    @ApiModelProperty(value = "燃油类型code")
    private String fuelTypeCode;

    @ExcelProperty(value = "最大载油量", index = 12)
    @ApiModelProperty(value = "最大载油量")
    private Double oilLoadMax;

    @ExcelProperty(value = "标准燃油", index = 13)
    @ApiModelProperty(value = "标准燃油")
    private Double standardFuel;

    @ExcelProperty(value = "空重", index = 14)
    @ApiModelProperty(value = "空重")
    private Double emptyWeight;

    @ExcelProperty(value = "飞机主要构造材料", index = 15)
    @ApiModelProperty(value = "飞机主要构造材料")
    private String structuralMaterial;

    @ExcelProperty(value = "氧气瓶数量", index = 16)
    @ApiModelProperty(value = "氧气瓶数量")
    private Integer oxygenCylinderNum;

    @ExcelProperty(value = "氧气瓶位置描述", index = 17)
    @ApiModelProperty(value = "氧气瓶位置描述")
    private String oxygenCylinderLocation;

    @ExcelProperty(value = "标准坐席数", index = 18)
    @ApiModelProperty(value = "标准坐席数")
    private Integer seatNum;

    @ExcelProperty(value = "商载(吨)", index = 19)
    @ApiModelProperty(value = "商载(吨)")
    private Double commercialLoad;

    @ExcelProperty(value = "货仓容积（立方米）", index = 20)
    @ApiModelProperty(value = "货仓容积（立方米）")
    private Double warehouseVolume;

    @ExcelProperty(value = "最大起飞总重（吨）", index = 21)
    @ApiModelProperty(value = "最大起飞总重（吨）")
    private Double takeoffWeightNum;

    @ExcelProperty(value = "最大巡航速度（马赫）", index = 22)
    @ApiModelProperty(value = "最大巡航速度（马赫）")
    private Double cruiseSpeedNum;

    @ExcelProperty(value = "航程", index = 23)
    @ApiModelProperty(value = "航程")
    private Double voyage;

    @ExcelProperty(value = "主要设施", index = 24)
    @ApiModelProperty(value = "主要设施")
    private String facilitie;

    @ExcelProperty(value = "主要燃烧物质", index = 25)
    @ApiModelProperty(value = "主要燃烧物质")
    private String combustionMaterial;

    @ExcelProperty(value = "疏散出口及安全通道", index = 26)
    @ApiModelProperty(value = "疏散出口及安全通道")
    private String exitPassage;

    @ExcelProperty(value = "备注", index = 27)
    @ApiModelProperty(value = "备注")
    private String remark;

    @ExcelProperty(value = "外观图", index = 28)
    @ApiModelProperty(value = "外观图")
    private String appearanceImages;

    @ExcelProperty(value = "平面图", index = 29)
    @ApiModelProperty(value = "平面图")
    private String planeImages;

    @ExcelProperty(value = "救援图", index = 30)
    @ApiModelProperty(value = "救援图")
    private String rescueImages;

    @ExcelProperty(value = "方位图", index = 31)
    @ApiModelProperty(value = "方位图")
    private String positionImages;

    @ExcelProperty(value = "三维模型", index = 32)
    @ApiModelProperty(value = "三维模型")
    private String models;

    @ApiModelProperty(value = "现场图片")
    private List<String> scenePicture;

}
