package com.yeejoin.amos.boot.module.jcs.api.service;


import java.util.List;
import java.util.Map;

import com.yeejoin.amos.boot.module.jcs.api.dto.AircraftDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.AircraftListTreeDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Aircraft;

/**
* 航空器信息接口类
*
* @author system_generator
* @date 2021-06-29
*/
public interface IAircraftService {
    AircraftDto queryByAircraftSeq(String agencyCode, Long seq);
    Aircraft queryByaircraftModel(String seq);
    
    List<AircraftListTreeDto> getAircraft();

    /**
     * 根据警情id查询航班信息
     *
     * @param alertId
     * @return
     */
    Map<String, Object> queryAircraftInfo(Long alertId);

    /**
     * 根据航空器型号查询航空器信息
     *
     * @param aircraftModel
     * @return
     */
    Aircraft queryAircraftInfoByModel(String aircraftModel);


    List< Map<String, Object>> queryAircraftList();
}
