package com.yeejoin.amos.latentdanger.common.enums;

import com.yeejoin.amos.boot.biz.common.utils.DynamicEnumUtil;

import java.util.HashMap;
import java.util.Map;

public enum LatentDangerStateEnum {
    待评审("待评审", "1"),
    待治理("待治理", "2"),
    安措计划中("安措计划中", "3"),
    待验证("待验证", "4"),
    治理完毕("治理完毕", "5"),
    已撤销("已撤销", "6"),
    延期治理申请("延期治理中", "7"),
    延期治理申请待车间部门审核("延期治理待车间部门审核", "8"),
    延期治理申请待公司审核("延期治理待公司审核", "9");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    /**
     * 枚举缓存
     */
    public static Map<String, LatentDangerStateEnum> enumMap = new HashMap<>();

    public static final String dictCode = "_GOVERNANCE_PROGRESS";

    LatentDangerStateEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static String getEnumName(String code) {
        return enumMap.get(code).getName();
    }

    public static LatentDangerStateEnum getByCode(String code) {
        return enumMap.get(code);
    }

    public static LatentDangerStateEnum addEnumDynamic(String enumName, String name, String code) {
        LatentDangerStateEnum dangerStateEnum = DynamicEnumUtil.addEnum(LatentDangerStateEnum.class, enumName,
                new Class[]{String.class, String.class}, new Object[]{name, code});
        enumMap.put(code, dangerStateEnum);
        return dangerStateEnum;
    }
}
