package com.yeejoin.amos.fas.business.action.mq;

import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.emq.EmqKeeper;

@Component
public class WebMqttComponent {
	@Autowired
    private EmqKeeper emqKeeper;
	
	public void publish(String topic, String jsonStr) {
		try {
			this.emqKeeper.getMqttClient().publish(topic, jsonStr.getBytes(), 2, false);
		} catch (MqttPersistenceException e) {
			e.printStackTrace();
		} catch (MqttException e) {
			e.printStackTrace();
		}
	}
}
