package com.yeejoin.amos.fas.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.fas.business.service.intfc.IDataRefreshService;
import com.yeejoin.amos.fas.common.enums.View3dRefreshAreaEum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据刷新
 */
@Service("dataRefreshService")
public class DataRefreshServiceImpl implements IDataRefreshService {

    private final Logger log = LoggerFactory.getLogger(DataRefreshServiceImpl.class);

//    @Autowired
//    private RemoteWebSocketServer remoteWebSocketServer;

    @Override
    public void refreshViewData(String dataType) {
        /*
         * check 巡检数据刷新（影响区域:消防安全执行、今日巡检）
         * planTask 执行数据刷新（影响区域:今日巡检）
        */
        Map<String,Object> param = new HashMap<>();
        List<View3dRefreshAreaEum> notifyAreaList = View3dRefreshAreaEum.getEumListByTrigger(dataType);
        notifyAreaList.forEach(eum->{
            param.clear();
            param.put("refreshType",eum.getCode());
            this.notifyDataRefresh(param);
        });
    }

    @Override
    public void sendRefreshDataWithArea(String areaType, Map content) {

        Map<String,Object> sendData = new HashMap<>(2);
        sendData.put("refreshType",areaType);
        sendData.put("content",content);
        this.notifyDataRefresh(sendData);
    }


    private void notifyDataRefresh(Map<String, Object> param) {
        try {
//            remoteWebSocketServer.sendMessage("3dViewMessage", JSON.toJSONString(param));
        } catch (Exception e) {
            log.error("通知前端数据刷新失败-->"+JSON.toJSONString(param));
            log.error("通知前端数据刷新失败-->"+e.getMessage());
        }
    }
}
