package com.yeejoin.amos.knowledgebase.face.service;


import java.util.Collection;
import java.util.List;

import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.yeejoin.amos.knowledgebase.face.model.KnowledgeTagValueModel;
import com.yeejoin.amos.knowledgebase.face.orm.dao.TagValueMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeTagValue;


/**
 * <p>
 * 值标签的实例值 服务类
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@Component
public class TagValueService extends BaseService<KnowledgeTagValueModel, KnowledgeTagValue, TagValueMapper> {

    @Transactional(rollbackFor = {Exception.class, BaseException.class})
    public List<KnowledgeTagValueModel> saveInstanceValue(Long instanceSeq, List<KnowledgeTagValueModel> valueModels, String unit) {

        this.deleteByInstanceId(instanceSeq);
        if (!ValidationUtil.isEmpty(valueModels)) {
            for (KnowledgeTagValueModel model : valueModels) {
                model.setAgencyCode(RequestContext.getAgencyCode());
                model.setInstanceSeq(instanceSeq);
                model.setUnit(unit);
                this.createWithModel(model);
            }
        }
        return valueModels;
    }


    public boolean deleteByInstanceId(Long instanceSeq) {
        List<KnowledgeTagValueModel> list = queryByInstance(instanceSeq);
        if (!ValidationUtil.isEmpty(list)) {
            for (KnowledgeTagValueModel model : list) {
                this.deleteBySeq(model.getSequenceNbr());
            }
        }
        return true;
    }


    public List<KnowledgeTagValueModel> queryByInstance(Long instanceSeq) {
        return this.queryForList("", false, instanceSeq);
    }

    public List<KnowledgeTagValueModel> queryTagValuesByDocId(Long docSeq) {
        return Bean.toModels(this.getBaseMapper().queryTagValuesByDocId(docSeq), KnowledgeTagValueModel.class);
    }

    public List<KnowledgeTagValueModel> queryTagValuesByDocIds(Collection<Long> docSeqList) {
        return Bean.toModels(this.getBaseMapper().queryTagValuesByDocIds(docSeqList), KnowledgeTagValueModel.class);
    }
}
