package com.yeejoin.amos.latentdanger.business.feign;

import com.yeejoin.amos.boot.module.common.api.feign.MultipartSupportConfig;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 机场服务feign
 *
 * @author Dell
 */
@FeignClient(name = "${jcs.fegin.name}", path = "jcs", configuration = {MultipartSupportConfig.class})
public interface JcsFeignClient {
    /**
     * 根据机场人员id获取amos平台人员id
     *
     * @param orgUserId 机场单位人员id
     * @return AgencyUserModel 平台人员信息
     **/
    @RequestMapping(value = "/org-usr/amos/{orgUserId}", method = RequestMethod.GET)
    ResponseModel<AgencyUserModel> getAmosIdByUserId(@PathVariable String orgUserId);
}
