package com.yeejoin.amos.supervision.business.util;

import java.util.HashMap;
import java.util.List;

import com.yeejoin.amos.supervision.business.param.PointImportQueryParam;
import com.yeejoin.amos.supervision.core.util.StringUtil;
import org.springframework.util.ObjectUtils;

import com.yeejoin.amos.supervision.core.common.request.CommonRequest;

public class PointParamUtils {
	public static HashMap<String, Object> fillTaskInfo(List<CommonRequest> queryRequests) {
		HashMap<String, Object> param = new HashMap<String, Object>();
		if (ObjectUtils.isEmpty(queryRequests)) {
			return param;
		}
		for (CommonRequest request : queryRequests) {
			if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getName())) {
				param.put(request.getName(), request.getValue());
			}
		}
		return param;
	}
	
	
	public static PointImportQueryParam fillPointImportQuery(List<CommonRequest> queryRequests){
		PointImportQueryParam param = new PointImportQueryParam();
		for(int i=0;i<queryRequests.size();i++){
			CommonRequest commonRequest = queryRequests.get(i);
			String name = commonRequest.getName();
			String value = commonRequest.getValue().toString();
			if(StringUtil.isNotEmpty(value)){
				if("name".equals(name)){
					param.setName(value);
				}else if("pointNo".equals(name)){
					param.setPointNo(value);
				}else if("isFixed".equals(name)){
					param.setIsFixed(value);
				}else if("orgCode".equals(name)){
					param.setOrgCode(value);
				}else if("catalogId".equals(name)){
					param.setCatalogId(Long.valueOf(value));
				}
			}
		}		
		return param;
		
	}
}
