package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 设备报警信息日志表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("asf_fire_equipment_alarm_log")
public class FireEquipmentAlarmLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     * 消防设备id
     */
    @TableField("fire_equipment_mrid")
    private String fireEquipmentMrid;

    /**
     * 设备名称
     */
    @TableField("fire_equipment_name")
    private String fireEquipmentName;

    /**
     * 指标名称
     */
    @TableField("fire_equipment_index_name")
    private String fireEquipmentIndexName;

    /**
     * 指标编码
     */
    @TableField("fire_equipment_index_key")
    private String fireEquipmentIndexKey;

    /**
     * 报警值
     */
    @TableField("fire_equipment_index_value")
    private String fireEquipmentIndexValue;

    /**
     * 建筑id（冗余字段）
     */
    @TableField("fire_building_mrid")
    private String fireBuildingMrid;

    /**
     * 报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）
     */
    @TableField("type")
    private String type;

    /**
     * 确认类型
     */
    @TableField("confirm_type")
    private String confirmType;

    /**
     * 确认类型名称
     */
    @TableField("confirm_type_name")
    private String confirmTypeName;

    /**
     * 报警原因
     */
    @TableField("alarm_reason")
    private String alarmReason;

    /**
     * 处理情况
     */
    @TableField("resolve_result")
    private String resolveResult;

    /**
     * 确警人员姓名
     */
    @TableField("confirm_user_name")
    private String confirmUserName;

    /**
     * 确警时间
     */
    @TableField("confirm_date")
    private Date confirmDate;

    /**
     * 装备所属消防系统code（冗余字段）
     */
    @TableField("system_mrids")
    private String systemMrids;

    /**
     * 装备定义code（冗余字段）
     */
    @TableField("equipment_definition_mrid")
    private String equipmentDefinitionMrid;

    /**
     * 装备定义名称
     */
    @TableField("equipment_definition_name")
    private String equipmentDefinitionName;

    /**
     * 设备位置
     */
    @TableField("location")
    private String location;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;

}
