package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireWaterDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireWaterServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 消防水源表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防水源表Api")
@RequestMapping(value = "/fire-water")
public class FireWaterController extends BaseController {

    @Autowired
    FireWaterServiceImpl fireWaterServiceImpl;

    /**
     * 新增消防水源表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增消防水源表", notes = "新增消防水源表")
    public ResponseModel<FireWaterDto> save(@RequestBody FireWaterDto model) {
        model = fireWaterServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新消防水源表", notes = "根据sequenceNbr更新消防水源表")
    public ResponseModel<FireWaterDto> updateBySequenceNbrFireWater(@RequestBody FireWaterDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(fireWaterServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除消防水源表", notes = "根据sequenceNbr删除消防水源表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireWaterServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个消防水源表", notes = "根据sequenceNbr查询单个消防水源表")
    public ResponseModel<FireWaterDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireWaterServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "消防水源表分页查询", notes = "消防水源表分页查询")
    public ResponseModel<Page<FireWaterDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<FireWaterDto> page = new Page<FireWaterDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireWaterServiceImpl.queryForFireWaterPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "消防水源表列表全部数据查询", notes = "消防水源表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireWaterDto>> selectForList() {
        return ResponseHelper.buildResponse(fireWaterServiceImpl.queryForFireWaterList());
    }
}
