package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * 
 *
 * @author system_generator
 * @date 2023-08-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("hygf_household_contract")
public class HouseholdContract extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 勘察状态
     */
	@TableField("survey_status")
    private String surveyStatus;

    /**
     * 合同状态
     */
	@TableField("status")
    private String status;

    /**
     * 签字状态
     */
	@TableField("sign_status")
    private String signStatus;

    /**
     * 盖章状态
     */
	@TableField("stamp_status")
    private String stampStatus;

    /**
     * 甲方
     */
	@TableField("party_a")
    private String partyA;

    /**
     * 乙方
     */
	@TableField("party_b")
    private String partyB;

    /**
     * 合同编号
     */
	@TableField("contract_number")
    private String contractNumber;

    /**
     * 农户编号
     */
	@TableField("peasant_household_number")
    private String peasantHouseholdNumber;

    /**
     * 农户身份证
     */
	@TableField("peasant_household_card")
    private String peasantHouseholdCard;

    /**
     * 经销商id
     */
	@TableField("dealer_id")
    private Long dealerId;

    /**
     * 经销商code
     */
	@TableField("dealer_code")
    private String dealerCode;

    /**
     * 经销商名称
     */
	@TableField("dealer_name")
    private String dealerName;

    /**
     * 合同名称
     */
	@TableField("name")
    private String name;

    /**
     * 模板id
     */
	@TableField("contract_template_id")
    private Long contractTemplateId;

    /**
     * 合同文件地址
     */
	@TableField("contract_url")
    private String contractUrl;

    /**
     * 办理人
     */
	@TableField("sealed_user")
    private String sealedUser;

    /**
     * 农户id
     */
	@TableField("peasant_household_id")
    private Long peasantHouseholdId;

    /**
     * 所属区域公司id
     */
	@TableField("regional_companies_seq")
    private Long regionalCompaniesSeq;

    /**
     * 所属区域公司名称
     */
	@TableField("regional_companies_name")
    private String regionalCompaniesName;

    /**
     * 所属区域公司code
     */
	@TableField("regional_companies_code")
    private String regionalCompaniesCode;

    /**
     * 农户手机号
     */
	@TableField("peasant_household_phone")
    private String peasantHouseholdPhone;

    /**
     * 项目详细地址
     */
	@TableField("project_address_detail")
    private String projectAddressDetail;

    /**
     * 常住详细地址
     */
	@TableField("permanent_address_detail")
    private String permanentAddressDetail;

    /**
     * 常住地址
     */
	@TableField("permanent_address_name")
    private String permanentAddressName;

    /**
     * 项目地址
     */
	@TableField("project_address_name")
    private String projectAddressName;

    /**
     * 免租期
免租期
     */
	@TableField("rent_free")
    private Date rentFree;

    /**
     * 租金计算日期
     */
	@TableField("rent_calculation_date")
    private Date rentCalculationDate;

    /**
     * 租期结束日期
     */
	@TableField("lease_end_date")
    private Date leaseEndDate;

    /**
     * 建设规模
     */
	@TableField("construction_scale")
    private Double constructionScale;

    /**
     * 组件数量块
     */
	@TableField("component_quantity_block")
    private Integer componentQuantityBlock;

    /**
     * 总投资
     */
	@TableField("total_investment")
    private Double totalInvestment;

    /**
     * 组件功率
     */
	@TableField("component_power")
    private Double componentPower;

    /**
     * 电站功率
     */
	@TableField("station_power")
    private Double stationPower;
    /***
     *合同契约锁id'
     * */
    @TableField("contract_lock_id")
    private Long contractLockId;

    /**
     * 印章id
     * */
    @TableField("seal_id")
    private Long sealId;

    /**
     *  发起状态
     * */
    @TableField("initiate_status")
    private String initiateStatus;
    /**
     *  签署时间
     * */

    @TableField("signing_time")
    private Date signingTime;


    @TableField("project_user_id")
    private String projectUserId;

    //合同填充字段值
    @TableField(exist = false)
    List<ContractFillData> contractFillData;

    //查询一个农户拥有的合同是否全是已废弃
    @TableField(exist = false)
    private Boolean isAllDisuse;
}
