package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingAuditingDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.FinancingAuditingServiceImpl;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;

import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 投融审核表
 *
 * @author system_generator
 * @date 2024-04-01
 */
@RestController
@Api(tags = "投融审核表Api")
@RequestMapping(value = "/financing-auditing")
public class FinancingAuditingController extends BaseController {

    @Autowired
	FinancingAuditingServiceImpl financingAuditingServiceImpl;

    /**
     * 新增投融审核表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增投融审核表", notes = "新增投融审核表")
	public ResponseModel<FinancingAuditingDto> save(@RequestBody FinancingAuditingDto model) {
	    model = financingAuditingServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新投融审核表", notes = "根据sequenceNbr更新投融审核表")
	public ResponseModel<FinancingAuditingDto> updateBySequenceNbrFinancingAuditing(@RequestBody FinancingAuditingDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(financingAuditingServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除投融审核表", notes = "根据sequenceNbr删除投融审核表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(financingAuditingServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个投融审核表",  notes = "根据sequenceNbr查询单个投融审核表")
	public ResponseModel<FinancingAuditingDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(financingAuditingServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "投融审核表分页查询",  notes = "投融审核表分页查询")
	public ResponseModel<Page<FinancingAuditingDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<FinancingAuditingDto> page = new Page<FinancingAuditingDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(financingAuditingServiceImpl.queryForFinancingAuditingPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "投融审核表列表全部数据查询",   notes = "投融审核表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FinancingAuditingDto>> selectForList() {
	    return ResponseHelper.buildResponse(financingAuditingServiceImpl.queryForFinancingAuditingList());
	}
}
