package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.hygf.api.dto.JpInverterElectricityDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverterElectricity;
import com.yeejoin.amos.boot.module.hygf.api.mapper.JpInverterElectricityMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IJpInverterElectricityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 户用光伏监盘逆变器电能表服务实现类
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Service
public class JpInverterElectricityServiceImpl
		extends BaseService<JpInverterElectricityDto, JpInverterElectricity, JpInverterElectricityMapper>
		implements IJpInverterElectricityService {
	
	@Autowired
	private JpStationServiceImpl jpStationServiceImpl;
	
	@Autowired
	private JpInverterServiceImpl JpInverterServiceImpl;
	
	/**
	 * 分页查询
	 */
	public Page<JpInverterElectricityDto> queryForJpInverterElectricityPage(Page<JpInverterElectricityDto> page) {
		return this.queryForPage(page, null, false);
	}

	/**
	 * 列表查询 示例
	 */
	public List<JpInverterElectricityDto> queryForJpInverterElectricityList(String id) {
		JpInverter jpInverter = JpInverterServiceImpl.getById(id);
		LambdaQueryWrapper<JpInverterElectricity> wrapper = new LambdaQueryWrapper<>();
		wrapper.eq(JpInverterElectricity::getSnCode, jpInverter.getSnCode());
		wrapper.eq(JpInverterElectricity::getThirdStationId, jpInverter.getThirdStationId());
		List<JpInverterElectricity> list = this.list(wrapper);
		return Bean.toModels(list, this.getModelClass());
	}
}