package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapBuilder;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizPvPointVarCorrelationDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvPointVarCorrelation;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizPvPointVarCorrelationMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.service.IIdxBizPvPointVarCorrelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-08-15
 */
@Service
public class IdxBizPvPointVarCorrelationServiceImpl extends BaseService<IdxBizPvPointVarCorrelationDto,IdxBizPvPointVarCorrelation,IdxBizPvPointVarCorrelationMapper> implements IIdxBizPvPointVarCorrelationService {
    @Autowired
    private  IdxBizPvPointVarCorrelationMapper idxBizPvPointVarCorrelationMapper;
    /**
     * 分页查询
     */
    public Page<IdxBizPvPointVarCorrelationDto> queryForIdxBizPvPointVarCorrelationPage(Page<IdxBizPvPointVarCorrelationDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<IdxBizPvPointVarCorrelationDto> queryForIdxBizPvPointVarCorrelationList()   {
        return this.queryForList("" , false);
    }

    public Map<String,Object> getCurrentChoosePoint(String gatewayId, String analysePointId) {
        List<IdxBizPvPointVarCorrelation> gongkuangList;
        gongkuangList = idxBizPvPointVarCorrelationMapper
                .selectList(new QueryWrapper<IdxBizPvPointVarCorrelation>()
                        .eq("ANALYSIS_GATEWAY_ID",
                                gatewayId)
                        .eq("ANALYSIS_POINT_ID",
                                analysePointId)
                        .eq("MATCH_PROCESS_POINT","匹配"));
        if (CollectionUtil.isEmpty(gongkuangList) || gongkuangList.size() !=3 ){
            gongkuangList = idxBizPvPointVarCorrelationMapper
                    .selectList(new QueryWrapper<IdxBizPvPointVarCorrelation>()
                            .eq("ANALYSIS_GATEWAY_ID",
                                    gatewayId)
                            .eq("ANALYSIS_POINT_ID",
                                    analysePointId)
                            .orderByDesc("CORRELATION_COEFFICIENT").last("limit 0,3"));
        }
        List<String> collect = gongkuangList.stream().map(IdxBizPvPointVarCorrelation::getProcessPointId).collect(Collectors.toList());
        return    MapBuilder.<String,Object>create().put("processPointIds",collect).build();
    }

    public void updatePointChoose(String gatewayId, Long analysePointId, List<String> processPointIds) {

        this.getBaseMapper().updatePointChoose(gatewayId,analysePointId,null);


        this.getBaseMapper().updatePointChoose(gatewayId,analysePointId,processPointIds);



    }

    public Map<String,Object> getPointProcess(String gatewayId, String analysePointId) {

        List<IdxBizPvPointVarCorrelation> gongkuangList = idxBizPvPointVarCorrelationMapper
                .selectList(new QueryWrapper<IdxBizPvPointVarCorrelation>()
                        .eq("ANALYSIS_GATEWAY_ID",
                                gatewayId)
                        .eq("ANALYSIS_POINT_ID",
                                analysePointId));

        return    MapBuilder.<String,Object>create().put("processPointIds",gongkuangList).build();
    }
}