package com.yeejoin.amos.api.householdapi.constant;

import java.util.HashMap;

/**
 * 碳银常量类
 * <p>
 * ProjectName: amos-boot-zx-biz
 * PackageName: com.yeejoin.amos.api.householdapi.constant
 *
 * @author yangyang
 * @version v1.0
 * @date 2024/7/15 10:22
 */
public class TanYinConstant {

    public static String ACCESS_TOKEN_KEY = "TanYin_Token";

    /**
     * 获取电站信息
     */
    public static String stationListUrl = "/v1/yx/query/station/info";
    /**
     * 获取客户信息
     */
    public static String customerInfoUrl = "/v1/yx/query/customer/info";
    /**
     * 电站逆变器信息接口
     */
    public static String inverterListUrl = "/v1/station/getTodayDetail";
    /**
     * 电站逆变器故障信息接口
     */
    public static String inverterAlramUrl = "/v1/yx/query/invert/fault";
    /**
     * 获取 Access_Token
     */
    public static String getAccessTokenUrl = "/v1/auth/getAccessToken";
    /**
     * 刷新 Access_Token
     */
    public static String refreshAccessTokenUrl = "/v1/auth/refreshAccessToken";

    public static final HashMap<String, String> stationStatus = new HashMap<String, String>() {
        {
            put("0", "在线");
            put("1", "离线");
            put("2", "异常");
        }
    };

    public static final HashMap<String, String> intoNetWorkStatus = new HashMap<String, String>() {
        {
            put("0", "固定全额上网");
        }
    };

}
