package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/12/13
 */
@Getter
@AllArgsConstructor
public enum DeliveryStateeEnum {


    待发货("待发货", "待发货"),

    暂存发货("暂存发货", "暂存发货"),
    待提交("待提交", "待提交"),
    待确认("待确认", "待确认"),
    待补货("待补货", "待补货"),

    待审核("待审核", "待审核"),

    已完成("已完成", "已完成"),

    已发货("已发货", "已发货"),

    已作废("已作废", "已作废");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    public static ContractStatusEnum getNodeByCode(String code) {
        ContractStatusEnum dealerReviewEnum = null;
        for(ContractStatusEnum type: ContractStatusEnum.values()) {
            if (type.getCode().equals(code)) {
                dealerReviewEnum = type;
                break;
            }
        }
        return dealerReviewEnum;
    }

}
