package com.yeejoin.amos.boot.module.hygf.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @description:还款消息状态枚举
 * @author: hzz
 * @createDate: 2023/12/13
 */
@Getter
@AllArgsConstructor
public enum RepaymentRepayStateEnum {
    UN_REPAY(0, "待还款"),
    REPAY(1, "已还款");
    /**
     * 编码
     */
    private Integer code;
    /**
     * 名称，描述
     */
    private String remark;

    public static RepaymentRepayStateEnum getByCode(Integer code) {
        RepaymentRepayStateEnum anEnum = null;
        for (RepaymentRepayStateEnum type : RepaymentRepayStateEnum.values()) {
            if (type.getCode() == code) {
                anEnum = type;
                break;
            }
        }
        return anEnum;
    }
}
