package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 审核单
 *
 * @author system_generator
 * @date 2024-08-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "HygfRectificationOrderDto", description = "审核单")
@JsonIgnoreProperties(ignoreUnknown = true)
public class HygfRectificationOrderDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "农户姓名")
    private String peasantHouseholeName;

    @ApiModelProperty(value = "农户编号")
    private String peasantHouseholeCode;

    @ApiModelProperty(value = "农户场站id")
    private String peasantHouseholeId;

    @ApiModelProperty(value = "整改项")
    private List<Object> rectificationIdea;

    @ApiModelProperty(value = "农户项目地址")
    private String projectAddressName;

    @ApiModelProperty(value = "整改附件")
    private List<Object> rectificationFile;

    @ApiModelProperty(value = "整改结果附件")
    private List<Object> resultFile;

    @ApiModelProperty(value = "整改结果")
    private List<Object> rectificationResult;


    @ApiModelProperty(value = "审核意见")
    private String auditIdea;

    @ApiModelProperty(value = "审核结果")
    private String auditResult;


    /**
     * 整改类型
     */
    private String rectificationType;


    /**
     * 整改来源
     */
    private String rectificationSource;


    /**
     * 整改历史意见
     */
    private List<Object> rectificationHistory;
    @ApiModelProperty(value = "整改结果-施工信息展示用")
    private String rectificationResultWeb;
    @ApiModelProperty(value = "整改历史意见-施工信息展示用")
    private String rectificationHistoryWeb;
    @ApiModelProperty(value = "整改项-施工信息展示用")
    private String rectificationIdeaWeb;

    /**
     * 负责人
     */
    private String projectRegionManager;

}
