package com.yeejoin.amos.boot.module.hygf.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.hygf.api.dto.TasksRole;
import com.yeejoin.amos.boot.module.hygf.api.entity.ToDoTasks;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人员任务 Mapper 接口
 *
 * @author system_generator
 * @date 2023-09-08
 */
public interface ToDoTasksMapper extends BaseMapper<ToDoTasks> {


    List<TasksRole> getTasksRole(@Param("roleId") String roleId, @Param("orgCode") String orgCode);

    String getRoleIdByName(@Param("groupName") String groupName);

    /**
     * 根据角色和区域公司获取用户Id
     * @param companyOrgCode
     * @param roleId
     * @return
     */
    List<String> getTodoUserIds(@Param("companyOrgCode") String companyOrgCode, @Param("roleId") String roleId);

    /**
     * 根据区域公司、角色、经销商获取待办的人员
     * @param companyOrgCode
     * @param roleId
     * @param amosOrgCode
     * @return
     */
    List<String> getTodoUserIdsByAmosDealer(@Param("companyOrgCode") String companyOrgCode, @Param("roleId") String roleId, @Param("amosOrgCode") String amosOrgCode);

    /**
     * 过滤用户根据管理端
     * @param companyOrgCode
     * @param userId
     * @return
     */
    List<String> filterUsersByAdmin(@Param("companyOrgCode") String companyOrgCode, @Param("list") List<String> userId);

    /**
     * 过滤用户根据经销商端
     * @param companyOrgCode
     * @param amosDealerCode
     * @param userId
     * @return
     */
    List<String> filterUsersByAmosDealer(@Param("companyOrgCode") String companyOrgCode, @Param("amosDealerCode") String amosDealerCode, @Param("list") List<String> userId);

    /**
     * 过滤经销商管理员
     * @param amosCompanyCode
     * @param userId
     * @return
     */
    List<String> filterUsersByAmosDealerAdmin(@Param("amosCompanyCode") String amosCompanyCode, @Param("list") List<String> userId);

    /**
     * 获取融资机构的待办人员
     * @param companyOrgCode
     * @param roleId
     * @return
     */
    List<String> getTodoUserIdsByRzjg(@Param("companyOrgCode") String companyOrgCode, @Param("roleId") String roleId);
}
