package com.yeejoin.amos.boot.module.hygf.biz.excel.factory;

import com.yeejoin.amos.boot.module.hygf.biz.excel.Enum.ExportPageEnum;
import com.yeejoin.amos.boot.module.hygf.biz.excel.impl.*;
import com.yeejoin.amos.boot.module.hygf.biz.excel.service.IExportPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

@Component
public class ExportPageFactory {
    @Autowired
    private DzjxzServiceImpl dzjxzService;
    @Autowired
    private DzbtgServiceImpl dzbtgService;
    @Autowired
    private DzwcServiceImpl dzwcService;
    @Autowired
    private TrdtsServiceImpl trdtsService;
    @Autowired
    private TrwtgServiceImpl trwtgService;
    @Autowired
    private TryfkServiceImpl tryfkService;
    @Autowired
    private TrdfkServiceImpl trdfkService;
    @Autowired
    private TrytsServiceImpl trytsService;
    @Autowired
    private RzdshServiceImpl rzdshService;
    @Autowired
    private RzdfkServiceImpl rzdfkService;
    @Autowired
    private RzyfkServiceImpl rzyfkService;
    @Autowired
    private RzwtgServiceImpl rzwtgService;
    @Autowired
    private SgysServiceImpl sgysService;
    @Autowired
    private BwysServiceImpl bwysService;
    @Autowired
    private YsshServiceImpl ysshService;
    @Autowired
    private FhdfhServiceImpl fhdfhService;
    @Autowired
    private FhyfhServiceImpl fhyfhService;

    public IExportPageService getExportPage(ExportPageEnum dataType) {
        switch (dataType) {
            case DZJXZ:
                return dzjxzService;
            case DZBTG:
                return dzbtgService;
            case DZWC:
                return dzwcService;
            case TRDTS:
                return trdtsService;
            case TRWTG:
                return trwtgService;
            case TRYFK:
                return tryfkService;
            case TRDFK:
                return trdfkService;
            case TRYTS:
                return trytsService;
            case RZDSH:
                return rzdshService;
            case RZDFK:
                return rzdfkService;
            case RZYFK:
                return rzyfkService;
            case RZWTG:
                return rzwtgService;
            case SGYS:
                return sgysService;
            case BWYS:
                return bwysService;
            case YSSH:
                return ysshService;
            case FHDFH:
                return fhdfhService;
            case FHYFH:
                return fhyfhService;
            default:
                throw new BadRequest("没有找到匹配的页面类型");
        }
    }
}
