package com.yeejoin.amos.boot.module.jxiop.biz.mapper2;

import org.apache.ibatis.annotations.Param;

public interface JXDZMapper {
    /**
     * 获取工作票总数
     * @param code
     * @return
     */
    Integer countWorkTicketTotalByCode(@Param("code") String code);

    /**
     * 获取处理中工作票总数
     * @param code
     * @return
     */
    Integer countWorkTicketProcessingByCode(@Param("code") String code);

    /**
     * 获取作废的工作票总数
     * @param code
     * @return
     */
    Integer countWorkTicketInvalidatedByCode(@Param("code") String code);

    /**
     * 获取已终结的工作票总数
     * @param code
     * @return
     */
    Integer countWorkTicketTerminatedByCode(@Param("code") String code);

    /**
     * 定期工作任务
     * @param code
     * @return
     */
    Integer countRegularTasksByCode(@Param("code") String code);

    /**
     * 巡检任务数量
     * @param code
     * @return
     */
    Integer countInspectionTasksByCode(@Param("code") String code);

    /**
     * 工单总数
     * @param code
     * @return
     */
    Integer countWorkOrderTotalByCode(@Param("code") String code);

    /**
     * 工单作废数
     * @param code
     * @return
     */
    Integer countWorkOrderInvalidatedByCode(@Param("code") String code);

    /**
     * 工单待开工数
     * @param code
     * @return
     */
    Integer countWorkOrderToBeOpenedByCode(@Param("code") String code);

    /**
     * 工单终结数
     * @param code
     * @return
     */
    Integer countWorkOrderTerminatedByCode(@Param("code") String code);

    /**
     * 工单开工数
     * @param code
     * @return
     */
    Integer countWorkOrderStartByCode(@Param("code") String code);

    /**
     * 获取设备Code
     * @param werks
     * @param value
     * @return
     */
    String getDeviceCode(@Param("werks") String werks, @Param("value") String value, @Param("replaceValue") String replaceValue);
}
