package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
* 维保合同
*
* @author system_generator
* @date 2021-07-16
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_contract")
public class Contract extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同名称
     */
	@TableField("name")
    private String name;
    /**
     * 签订单位名称
     */
	@TableField("signed_company")
    private String signedCompany;
    /**
     * 签订单位id
     */
	@TableField("signed_company_id")
    private Long signedCompanyId;
    /**
     * 合同开始日期
     */
	@TableField("begin_date")
    private Date beginDate;
    /**
     * 合同结束日期
     */
	@TableField("end_date")
    private Date endDate;
    /**
     * 签订日期
     */
	@TableField("signed_date")
    private Date signedDate;
    /**
     * 合同编号
     */
	@TableField("contract_no")
    private String contractNo;
    /**
     * 机构代码用于权限过滤
     */
	@TableField("org_code")
    private Boolean orgCode;
    /**
     * 单位名称
     */
	@TableField("company")
    private String company;
    /**
     * 单位id
     */
	@TableField("company_id")
    private Long companyId;
    /**
     * 单位类型（1维保单位，0联动单位）
     */
	@TableField("company_type")
    private String companyType;
    /**
     * 合同类型code
     */
	@TableField("type_code")
    private String typeCode;
    /**
     * 合同类型
     */
	@TableField("type")
    private String type;
    /**
     * 服务内容
     */
	@TableField("service_content")
    private String serviceContent;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
}
