package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.common.api.entity.DutyPersonShift;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 值班人员日期关联关系表 Mapper 接口
 *
 * @author system_generator
 * @date 2021-07-06
 */
public interface DutyPersonShiftMapper extends BaseMapper<DutyPersonShift> {

    /**
     * 计算班次最大执勤人数，时间区间内
     * 计算天的最大班次数量，时间区间内
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @param appKey    应用标识
     * @param groupCode 分组标识
     * @return Map
     */
    Map<String, Long> calMaxPersonAndShiftNum(
            @Param("beginDate") String beginDate,
            @Param("endDate") String endDate,
            @Param("appKey") String appKey,
            @Param("groupCode") String groupCode
    );

    /**
     * 银行日历视图
     *
     * @param dutyDate  日期
     * @param appKey    应用标识
     * @param groupCode 分组标识
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> bankViewData(
            @Param("dutyDate") String dutyDate,
            @Param("appKey") String appKey,
            @Param("groupCode") String groupCode
    );

    /**
     * 换流站日历视图
     *
     * @param dutyDate  日期
     * @param appKey    应用标识
     * @param groupCode 分组标识
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> stationViewData(
            @Param("dutyDate") String dutyDate,
            @Param("appKey") String appKey,
            @Param("groupCode") String groupCode
    );


    /**
     * 利用mysql 生成连续时间区间
     *
     * @param beginDate 开始日期
     * @param endDate   结束日期
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> genRangeDate(
            @Param("beginDate") String beginDate,
            @Param("endDate") String endDate
    );
}
