package com.yeejoin.amos.knowledgebase.face.util.sql;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.Getter;

import java.util.Map;
import java.util.Set;

/**
 * 自定义查询体
 * @author tiantao
 */
@Getter
abstract public class BaseSqlCondition {
    /**
     * 条件类型
     */
    private static final String CONDITION_TYPE = "conditionType";
    private static final String BLOCK = "block";
    private static final String CONDITION = "condition";
    /**
     * 逻辑关系
     */
    private String logic;

    BaseSqlCondition(Map<String, Object> resourceMap) {
        this.logic = (String) resourceMap.get("logic");
    }

    public static BaseSqlCondition getInstance(Map<String, Object> resourceMap) {
        String type = (String) resourceMap.get(CONDITION_TYPE);
        BaseSqlCondition sqlCondition;
        if (BLOCK.equals(type)) {
            sqlCondition = new SqlBlock(resourceMap);
        } else if (CONDITION.equals(type)) {
            sqlCondition = new SqlStatement(resourceMap);
        } else {
            throw new RuntimeException("条件格式错误");
        }
        if (!sqlCondition.validate()) {
            throw new RuntimeException("条件格式错误");
        }
        return sqlCondition;
    }

    public <T> void compose(QueryWrapper<T> queryWrapper) {
        composeWrapper(queryWrapper, "and");
    }

    /**
     * 组装条件到QueryWrapper
     *
     * @param queryWrapper 查询语句
     * @param logic        与上个条件的逻辑关系
     * @param <T>          泛型
     */
    abstract <T> void composeWrapper(QueryWrapper<T> queryWrapper, String logic);

    /**
     * 检查数据格式及完整性
     * @return 是否合格
     */
    abstract boolean validate();

    public abstract Set<String> getTagSeqs();

    public abstract int getTotalStatement();

}
