package com.yeejoin.amos.fas.business.controller;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.component.rule.RuleTrigger;
import com.yeejoin.amos.fas.business.action.model.ContingencyRo;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentHandlerService;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/safeuser")
@Api(tags="公司选择api")
public class SafetyController extends AbstractBaseController{
	private final Logger log = LoggerFactory.getLogger(SafetyController.class);
	
	
    @Autowired
    private RuleTrigger ruleTrigger;

	@Autowired
	IEquipmentHandlerService equipmentHandlerService;
	
	
	 /**
     * 	保存登陆用户选择公司信息
     */
    @ApiOperation(value = "  保存登陆用户选择公司信息", notes = " 保存登陆用户选择公司信息")
    @PostMapping(value = "/save/curCompany")
    public CommonResponse saveCurCompany(@RequestBody ReginParams reginParams) {
//        this.saveSelectedOrgInfo(reginParams);
        return CommonResponseUtil.success();
    }
	

    @GetMapping(value = "/test")
    public CommonResponse test() {
    	ContingencyRo newFact = new ContingencyRo();
    	newFact.setEquipmentId("0");;
    	try {
    		String token = (String) request.getHeader("token");
    		token = ObjectUtils.isEmpty(token) ? (String) request.getHeader("X-Access-Token") : token;
    		String product = (String) request.getHeader("product");
    		String appKey = (String) request.getHeader("appKey");
    		RequestContext.setToken(token);
    		RequestContext.setProduct(product);
    		RequestContext.setAppKey(appKey);
			Object o = ruleTrigger.publish(newFact, "换流站消防专项预案/test", ArrayUtils.toArray());
			return CommonResponseUtil.success(o);
		} catch (Exception e) {
			e.printStackTrace();
		}
        return CommonResponseUtil.failure();
    }
}
