package com.yeejoin.amos.boot.module.tzs.biz.controller;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.tzs.api.dto.MainPersonDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.WechatDispatchFeedbackDto;
import com.yeejoin.amos.boot.module.tzs.api.dto.WechatMyTaskDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.tzs.api.dto.DispatchTaskDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.DispatchTask;
import com.yeejoin.amos.boot.module.tzs.biz.service.impl.DispatchTaskServiceImpl;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 派遣任务
 *
 * @author system_generator
 * @date 2021-08-03
 */
@RestController
@Api(tags = "派遣任务Api")
@RequestMapping(value = "/dispatch-task")
public class DispatchTaskController extends BaseController {

    @Autowired
    DispatchTaskServiceImpl dispatchTaskServiceImpl;

	@Autowired
	RedisUtils redisUtils;

	/**
	 * 根据派遣单位类型和警情id 获取任务模板
	 * @param orgTypeCode
	 * @param alertId
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{orgTypeCode}/alert/{alertId}")
	@ApiOperation(httpMethod = "GET",value = "根据派遣单位类型和警情id 获取任务信息",  notes = "根据派遣单位类型和警情id 获取任务信息")
	public ResponseModel<DispatchTaskDto> selectOne(@PathVariable String orgTypeCode, @PathVariable Long alertId) {
		return ResponseHelper.buildResponse(dispatchTaskServiceImpl.getTaskInfo(orgTypeCode,alertId));
	}

    /**
     * 新增派遣任务
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增派遣任务", notes = "新增派遣任务")
	public ResponseModel<Boolean> save(@RequestBody DispatchTaskDto model) {
		ReginParams reginParams =getSelectedOrgInfo();
		Boolean flag = dispatchTaskServiceImpl.createDispatchTask(model,reginParams.getUserModel());
	    return ResponseHelper.buildResponse(flag);
	}

	/**
	 * 根据警情id 查找力量调派信息
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据警情id 查找力量调派信息",   notes = "根据警情id 查找力量调派信息")
	@GetMapping(value = "/list/alert/{alertId}")
	public ResponseModel<List<DispatchTask>> selectForListByAlertId(@PathVariable Long alertId) {
		LambdaQueryWrapper<DispatchTask> queryWrapper = new LambdaQueryWrapper<DispatchTask>();
		queryWrapper.eq(DispatchTask::getAlertId, alertId);
		List<DispatchTask> list = dispatchTaskServiceImpl.list(queryWrapper);
	    return ResponseHelper.buildResponse(list);
	}

	/**
	 * 微信公众号维修反馈接口
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/saveWechatFeed")
	@ApiOperation(httpMethod = "POST", value = "微信公众号维修反馈接口", notes = "微信公众号维修反馈接口")
	public ResponseModel<WechatMyTaskDto> saveWechatFeedBack(@RequestBody WechatDispatchFeedbackDto model) {
		return ResponseHelper.buildResponse(dispatchTaskServiceImpl.saveWechatFeedBack(model));
	}

	/**
	 * 查找当日派遣人员信息
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查找当日派遣人员信息",   notes = "查找当日派遣人员信息")
	@GetMapping(value = "/list/todayTaskPerson")
	public ResponseModel<List<MainPersonDto>> todayTaskPerson() {
		List<MainPersonDto> list = dispatchTaskServiceImpl.todayTaskPerson();
		return ResponseHelper.buildResponse(list);
	}
}
