package com.yeejoin.amos;

import java.net.InetAddress;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

/**
 * 
 * <pre>
 * 
 * </pre>
 *
 * @author gwb
 * @version $Id: OpenapiApplication.java, v 0.1 2021年9月27日 下午3:29:30 gwb Exp $
 */
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
//@EnableDiscoveryClient
//@EnableFeignClients
@EnableAsync
//@EnableEurekaClient
@EnableScheduling
@MapperScan(value = { "org.typroject.tyboot.*.*.face.orm.dao", "com.yeejoin.amos.api.*.face.orm.dao",
		"org.typroject.tyboot.face.*.orm.dao*", "com.yeejoin.amos.boot.biz.common.dao.mapper" })
@ComponentScan(value = { "org.typroject",
		"com.yeejoin.amos" }, excludeFilters = @ComponentScan.Filter(type = FilterType.REGEX, pattern = "org.typroject.tyboot.component.event"))
@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class,
		DataSourceTransactionManagerAutoConfiguration.class })
public class HousevPVapiApplication {
	private static final Logger logger = LogManager.getLogger(HousevPVapiApplication.class);

	public static void main(String[] args) throws Exception {
		// 服务启动
		ConfigurableApplicationContext context = SpringApplication.run(HousevPVapiApplication.class, args);
		GlobalExceptionHandler.setAlwaysOk(true);
		Environment env = context.getEnvironment();
		String ip = InetAddress.getLocalHost().getHostAddress();
		String port = env.getProperty("server.port");
		String path = env.getProperty("server.servlet.context-path");
		logger.info("\n----------------------------------------------------------\n\t"
				+ "Application Amos-Biz-Boot is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
				+ path + "/doc.html\n" + "----------------------------------------------------------");
	}
}
