package com.yeejoin.amos.boot.module.hygf.api.Enum;

/**
 * 业务类型枚举
 *
 * @author Administrator
 */
public enum BusinessTypeEnum {

    /**
     * 业务类型枚举
     */
    HYGF_JXS_SH("JXS_SH", "经销商审核"),
    HYGF_DZ_SH("hygf_10001", "电站审核"),
    HYGF_BWYS("hygf_bwys", "并网验收"),
    HYGF_DZTRRZ("StationFinancing", "电站投融资流程");
    private final String code;

    private final String name;

    BusinessTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (BusinessTypeEnum enumOne : BusinessTypeEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
