package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizFanPointVarCorrelationDto;
import com.yeejoin.amos.boot.module.jxiop.biz.dto.IdxBizPvPointVarCorrelationDto;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanPointVarCorrelation;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvPointVarCorrelation;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.IdxBizPvPointVarCorrelationServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * 
 *
 * @author system_generator
 * @date 2023-08-15
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/idx-biz-pv-point-var-correlation")
public class IdxBizPvPointVarCorrelationController extends BaseController {

    @Autowired
    IdxBizPvPointVarCorrelationServiceImpl idxBizPvPointVarCorrelationServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<IdxBizPvPointVarCorrelationDto> save(@RequestBody IdxBizPvPointVarCorrelationDto model) {
	    model = idxBizPvPointVarCorrelationServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<IdxBizPvPointVarCorrelationDto> updateBySequenceNbrIdxBizPvPointVarCorrelation(@RequestBody IdxBizPvPointVarCorrelationDto model,@PathVariable(value = "sequenceNbr") String sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(idxBizPvPointVarCorrelationServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(idxBizPvPointVarCorrelationServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<IdxBizPvPointVarCorrelationDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(idxBizPvPointVarCorrelationServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<Page<IdxBizPvPointVarCorrelationDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<IdxBizPvPointVarCorrelationDto> page = new Page<IdxBizPvPointVarCorrelationDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(idxBizPvPointVarCorrelationServiceImpl.queryForIdxBizPvPointVarCorrelationPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<IdxBizPvPointVarCorrelationDto>> selectForList() {
	    return ResponseHelper.buildResponse(idxBizPvPointVarCorrelationServiceImpl.queryForIdxBizPvPointVarCorrelationList());
	}



	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询当前点位所选择的工况变量",   notes = "查询当前点位所选择的工况变量")
	@GetMapping(value = "/getCurrentChoosePoint")
	public ResponseModel<Map<String,Object>> getCurrentChoosePoint(String gatewayId, String analysePointId) {

		return ResponseHelper.buildResponse(idxBizPvPointVarCorrelationServiceImpl.getCurrentChoosePoint(gatewayId,analysePointId));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询当前点位所选择的工况变量",   notes = "查询当前点位所选择的工况变量")
	@PostMapping(value = "/updatePointChoose")
	public ResponseModel updatePointChoose(@RequestBody IdxBizFanPointVarCorrelationDto dto) {


		idxBizPvPointVarCorrelationServiceImpl.updatePointChoose(dto.getAnalysisGatewayId(),dto.getAnalysisPointId(),dto.getProcessPointIds());
		return CommonResponseUtil.success();
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询当前点位的工况变量",   notes = "查询当前点位的工况变量")
	@GetMapping(value = "/getPointProcess")
	public ResponseModel<Map<String,Object>> getPointProcess(String gatewayId, String analysePointId) {
		return ResponseHelper.buildResponse(idxBizPvPointVarCorrelationServiceImpl.getPointProcess(gatewayId,analysePointId));
	}

}
