//package com.yeejoin.equip.utils;
//
//import com.yeejoin.equip.config.ElasticSearchConfig;
//import lombok.RequiredArgsConstructor;
//import org.apache.http.HttpHost;
//import org.apache.http.auth.AuthScope;
//import org.apache.http.auth.UsernamePasswordCredentials;
//import org.apache.http.client.CredentialsProvider;
//import org.apache.http.impl.client.BasicCredentialsProvider;
//import org.elasticsearch.client.RestClient;
//import org.elasticsearch.client.RestClientBuilder;
//import org.elasticsearch.client.RestHighLevelClient;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
//import org.springframework.boot.context.properties.EnableConfigurationProperties;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//import org.springframework.util.Assert;
//import org.springframework.util.StringUtils;
//import java.util.ArrayList;
//import java.util.List;
//
///**
// * Elasticsearch自动配置
// *
// * @author LiuLin
// * @version v1.0
// * @since 2024-01-15
// */
//@Configuration
//@RequiredArgsConstructor(onConstructor_ = @Autowired)
//@EnableConfigurationProperties(ElasticSearchConfig.class)
//public class ElasticsearchAutoConfiguration {
//
//    private final ElasticSearchConfig elasticSearchConfig;
//    private final List<HttpHost> httpHosts = new ArrayList<>();
//
//    @Bean
//    @ConditionalOnMissingBean
//    public RestHighLevelClient restHighLevelClient() {
//
//        List<String> clusterNodes = elasticSearchConfig.getClusterNodes();
//        clusterNodes.forEach(node -> {
//            try {
//                String[] parts = StringUtils.split(node, ":");
//                Assert.notNull(parts, "Must defined");
//                Assert.state(parts.length == 2, "Must be defined as 'host:port'");
//                httpHosts.add(new HttpHost(parts[0], Integer.parseInt(parts[1]), elasticSearchConfig.getSchema()));
//            } catch (Exception e) {
//                throw new IllegalStateException("Invalid ES nodes " + "property '" + node + "'", e);
//            }
//        });
//        RestClientBuilder builder = RestClient.builder(httpHosts.toArray(new HttpHost[0]));
//
//        return getRestHighLevelClient(builder, elasticSearchConfig);
//    }
//
//
//    /**
//     * get restHistLevelClient
//     *
//     * @param builder                 RestClientBuilder
//     * @param elasticSearchConfig elasticsearch default properties
//     * @return {@link RestHighLevelClient}
//     */
//    private static RestHighLevelClient getRestHighLevelClient(RestClientBuilder builder, ElasticSearchConfig elasticSearchConfig) {
//
//        // Callback used the default {@link RequestConfig} being set to the {@link CloseableHttpClient}
//        builder.setRequestConfigCallback(requestConfigBuilder -> {
//            requestConfigBuilder.setConnectTimeout(elasticSearchConfig.getConnectTimeout());
//            requestConfigBuilder.setSocketTimeout(elasticSearchConfig.getSocketTimeout());
//            requestConfigBuilder.setConnectionRequestTimeout(elasticSearchConfig.getConnectionRequestTimeout());
//            return requestConfigBuilder;
//        });
//
//        // Callback used to customize the {@link CloseableHttpClient} instance used by a {@link RestClient} instance.
//        builder.setHttpClientConfigCallback(httpClientBuilder -> {
//            httpClientBuilder.setMaxConnTotal(elasticSearchConfig.getMaxConnectTotal());
//            httpClientBuilder.setMaxConnPerRoute(elasticSearchConfig.getMaxConnectPerRoute());
//            return httpClientBuilder;
//        });
//
//        // Callback used the basic credential auth
//        ElasticSearchConfig.Account account = elasticSearchConfig.getAccount();
//        if (!StringUtils.isEmpty(account.getUsername()) && !StringUtils.isEmpty(account.getUsername())) {
//            final CredentialsProvider credentialsProvider = new BasicCredentialsProvider();
//
//            credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(account.getUsername(), account.getPassword()));
//        }
//        return new RestHighLevelClient(builder);
//    }
//}