package com.yeejoin.amos.api.householdapi.face.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.api.householdapi.face.model.HouseholdPvApiDto;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFStationDayGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.tdeingine.TdHYGFStationMonthGenerate;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.houseapi.HouseholdPvApiMapper;
import com.yeejoin.amos.api.householdapi.face.orm.houseapi.entity.houseapi.HouseholdPvApi;
import com.yeejoin.amos.api.householdapi.face.orm.mapper.tdengine.TdHYGFStationDayGenerateMapper;
import com.yeejoin.amos.api.householdapi.face.service.IHouseholdPvApiService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Date;
import java.util.List;

/**
 * 户用光伏-厂商API haders服务实现类
 *
 * @author system_generator
 * @date 2023-06-07
 */
@Service
public class HouseholdPvApiServiceImpl extends BaseService<HouseholdPvApiDto, HouseholdPvApi, HouseholdPvApiMapper> implements IHouseholdPvApiService {
    @Autowired
    public TdHYGFStationDayGenerateMapper TdHYGFStationDayGenerateMapper;


    /**
     * 分页查询
     */
    public Page<HouseholdPvApiDto> queryForHouseholdPvApiPage(Page<HouseholdPvApiDto> page)   {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<HouseholdPvApiDto> queryForHouseholdPvApiList()   {
        return this.queryForList("" , false);
    }

    public void addTdHYGFStationDayGenerate(TdHYGFStationMonthGenerate tdHYGFStationMonthGenerate,String currentTime){
        TdHYGFStationDayGenerate tdHYGFStationDayGenerate = TdHYGFStationDayGenerateMapper.selectOne(
                new QueryWrapper<TdHYGFStationDayGenerate>().eq("third_station_id", tdHYGFStationMonthGenerate.getThirdStationId())
                        .eq("day_time", DateUtil.format(new Date(), "yyyy-MM-dd"))
                        .eq("hour", currentTime)
                        .eq("year_month", DateUtil.format(new Date(), "yyyy-MM")));
        Long createdTime = System.currentTimeMillis();
        boolean flag= false;
        if (ObjectUtils.isEmpty(tdHYGFStationDayGenerate)) {
            tdHYGFStationDayGenerate = new TdHYGFStationDayGenerate();

             flag= true;
        }else {
            createdTime =  tdHYGFStationDayGenerate.getCreatedTime();
        }
        BeanUtils.copyProperties(tdHYGFStationMonthGenerate,tdHYGFStationDayGenerate);
        tdHYGFStationDayGenerate.setHour(currentTime);
        if (tdHYGFStationDayGenerate.getStationState().equals("离线")){
            tdHYGFStationDayGenerate.setGenerate(null);
        }
        if (flag){
            tdHYGFStationDayGenerate.setCreatedTime(System.currentTimeMillis());
        }else {
            tdHYGFStationDayGenerate.setCreatedTime(createdTime);
        }
        TdHYGFStationDayGenerateMapper.insert(tdHYGFStationDayGenerate);
    }

}